<?php
$start_time = gettimeofday();

define('IN_VSP', true);
require "./util.php";
require "./all.inc.php";
require getConfig();

require "{$GLOBALS['cfg']['db']['adodb_path']}".'adodb.inc.php';
$db = ADONewConnection("{$GLOBALS['cfg']['db']['adodb_driver']}");
if (!$db->Connect($GLOBALS['cfg']['db']['hostname'], $GLOBALS['cfg']['db']['username'], $GLOBALS['cfg']['db']['password'], $GLOBALS['cfg']['db']['dbname'])) {
    print "Error: cannot establish database connection\n";
    exit();
}
//$db->SetFetchMode(ADODB_FETCH_ASSOC);
$db->SetFetchMode(ADODB_FETCH_NUM);

if (isset($_GET['awardID'])) {
  $awardID = filter_input(INPUT_GET, 'awardID', FILTER_DEFAULT);
  if ($awardID !== null && !is_numeric($awardID)) {
  // Handle invalid input here
}
} else {
    $sql = "SELECT awardID FROM {$GLOBALS['cfg']['db']['table_prefix']}awards WHERE LENGTH(playerID) > 0 ORDER BY rand()";
    $rs = $db->SelectLimit($sql, 1, 0);
    $awardID = $rs->fields[0];
}

$qawardID = $db->qstr($awardID); // awardID quoted for sql


setSkin();
setupVars();


?>
<!DOCTYPE html>
<html lang="en-US" dir="ltr">
<head>
<meta charset="utf-8">
<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
<link rel="manifest" href="favicon/site.webmanifest">
<link rel="stylesheet" href="css/style.css" type="text/css">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<title>VSP™ (award stats)</title>
<link rel="stylesheet" href="<?php print $GLOBALS['stylesheet']; ?>" TYPE="text/css">
</head>
<?php ob_start("compactHTML");?>
<body>
<?php
//*************************************************************************
function setupVars()
{
    if (!is_dir("../../games/{$GLOBALS['cfg']['game']['name']}")) {
        $GLOBALS['cfg']['game']['name'] = 'default';
    }
}
//*************************************************************************
function drawHeadBar()
{
    global $sort,$config; ?>
  <!-- navbar begin          ################################################-->
  <table class="cellHeading,vsppadding1" width="100%">
    <tr>
    <td height="25" class="cellHeading" style="border-right-width: 0; text-align: left;" >
      <b>Award Stats</b>
    </td>
    </tr>
  </table>
  <!-- navbar end            ################################################-->
  <?php
}
//*************************************************************************
function drawAllAwards()
{
    global $db,$award_image;
  
    $sql="SELECT awardID,name,category,image,playerName,A.playerID 
          FROM {$GLOBALS['cfg']['db']['table_prefix']}awards as A, {$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP 
          WHERE PP.playerID=A.playerID 
          ORDER BY category,name ASC";
  
    $rs = $db->Execute($sql);
  
    if ($rs && !$rs->EOF) {
        ?>
    <!-- allawards table begin ##################################################-->
    <table class="vsppadding2" width="100%">
    <tr>
      <td colspan=3 width="100%"  class="cellHeading" style="text-align: center">Awards List</td>
    </tr>
    <?php
    do {
        ?>
      <tr>
        <td colspan="3" width="100%"  class="cellSubHeading" style="text-align: center "><?php print $rs->fields[2]; ?></td>
      </tr>    
      <?php
      $count = 0;
        do {
            $count++;
            if ($count%2 == 1) {
                $cell_class = "cell1";
            } else {
                $cell_class = "cell2";
            }
            $cat = $rs->fields[2];



            $award_images[] = "";
            unset($award_images);
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}".".webp";
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}".".jpg";
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}".".png";
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.webp";
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.jpg";
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.png";
            $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/default/default.webp";
            $award_images[] = "../../games/default/awardsets/default/default.webp";

            $no_of_award_images=count($award_images);
            for ($i = 0; $i < $no_of_award_images; $i++) {
                if (is_file($award_images[$i])) {
                    $award_image = $award_images[$i];
                    break;
                }
            }
            ?>
        <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
          <td style="text-align: center"><a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>"><img alt="" name="<?php print "AWARD_".$rs->fields[0]; ?>" src="<?php print $award_image; ?>"></a></td>
          <td style="text-align: left" width="100%">
            <a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>">
            <?php print processColors(htmlspecialchars($rs->fields[1]), $GLOBALS['settings']['display']['color_names'], 0); ?>
            </a>
          </td>
          <td style="text-align: center">
            <a href="playerstat.php?playerID=<?php print rawurlencode($rs->fields[5])."&amp;config=$GLOBALS[config]"; ?>">
            <?php print processColors(htmlspecialchars($rs->fields[4]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length']); ?>
            </a>
          </td>
        </tr>
        <?php
        } while ($rs->MoveNext()  && strcmp($cat, $rs->fields[2]) == 0);
    } while (!$rs->EOF); ?>
    </table>
    <!-- allawards table end ##################################################-->
    <?php
    }
}
//*************************************************************************
function drawAwardList()
{
    global $db,$start_from;
    $start_from = 0;
    $sql = "SELECT `sql`,name 
          FROM {$GLOBALS['cfg']['db']['table_prefix']}awards as A
          WHERE A.awardID = {$GLOBALS['qawardID']}";
    $rs = $db->SelectLimit($sql, 1, 0);
  
    $award_name = $rs->fields[1];
  
  
  
    $rs = $db->SelectLimit($rs->fields[0], $GLOBALS['cfg']['display']['record_limit'], $GLOBALS['start_from']);
  
    $no_of_cols = count($rs->fields);
    if ($rs && !$rs->EOF) {
        ?>
    <!-- awardstats table begin ##################################################-->
    <table class="vsppadding2" width="100%">
      <tr>
      <td class="cellHeading" style="text-align: center" colspan="<?php echo $no_of_cols?>">Award Listing for <?php echo fstr($award_name); ?> (top <?php echo $GLOBALS['cfg']['display']['record_limit']; ?>) </td>
      </tr>


      <tr>
      <td class="cellSubHeading" style="text-align: right">#</td>
      <td class="cellSubHeading" style="text-align: left" width="100%">Player Name</td>
      <?php
      for ($i = 2; $i < $no_of_cols; $i++) {
          $fldi = $rs->FetchField($i); ?>
        <td class="cellSubHeading" style="text-align: center">
        <?php print "&nbsp;".fstr($fldi->name)."&nbsp;"; ?>
        </td>
        <?php
      } ?>
      </tr>
    <?php
    $count = 0;
        do {
            $count++;
            if ($count % 2 == 1) {
                $cell_class = "cell1";
            } else {
                $cell_class = "cell2";
            } ?>
      <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >
      <td><?php print $count ?></td>

      <td style="text-align: left" >
      <a href="playerstat.php?playerID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>">
      <?php print processColors(htmlspecialchars($rs->fields[1]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length']); ?>
      </a>
      </td>

      <?php

      for ($i = 2; $i < $no_of_cols; $i++) {
          ?>
        <td style="text-align: center">
        <?php print $rs->fields[$i]; ?>
        </td>
        <?php
      } ?>
      </tr>
      <?php
        } while ($rs->MoveNext()); ?>
    </table>
    <!-- awardstats table end ##################################################-->
    <?php
    }
}
//*************************************************************************


?>



<!-- layout table begin ##################################################-->
<table class="vspborderwidth2" width="100%">

<tr>
  <td colspan="3" class="cellBG" style="vertical-align: top; padding: 0;">
    <?php drawMainHeading(); ?>
  </td>
</tr>

<tr>
  <td colspan=3 style="border-width: 0; padding: 0; ">
    <?php drawMenu(); ?>
  </td>
</tr>

<tr>
  <td colspan="2" class="cellBG" style="vertical-align: top; padding: 10px 10px 10px 10px; border-width: 0;">
    <?php drawHeadBar(); ?>
  </td>
</tr>

<tr>
  <td class="cellBG" style="vertical-align: top; padding: 0 0 10px 10px; border-width: 0;">
    <?php drawAllAwards(); ?>
  </td>

  <td class="cellBG" style="vertical-align: top; padding: 0 10px 10px 10px; border-width: 0 0 0 0;" width="100%">
    <?php drawAwardList(); ?>
  </td>
</tr>

<tr>
  <td colspan="2" class="cellBG" style="vertical-align: top; padding: 0; border-width: 0;">
    <?php drawCredits(); ?>
  </td>
</tr>

</table>
<!-- layout table end ##################################################-->

</body>
</html>