<?php
runAlways();
//******************************************************************************
function runAlways()
{
  define("cROOT_PATH", realpath(dirname(realpath(__FILE__)) . "/../../"));

  require "./settings.php";

  if (isset($GLOBALS['cfg']['db']['adodb_path'])) {
    $GLOBALS['cfg']['db']['adodb_path'] = fixPath($GLOBALS['cfg']['db']['adodb_path']);
  } else {
    $GLOBALS['cfg']['db']['adodb_path'] = fixPath(cROOT_PATH) . 'lib/adodb/';
  }
}
//******************************************************************************
function includeDOMTT()
{
?>
  <script type="text/javascript" language="javascript" src="../../lib/domTT/domLib.js"></script>
  <script type="text/javascript" language="javascript" src="../../lib/domTT/domTT.js"></script>
  <script language="JavaScript" type="text/javascript">
    var domTT_useGlobalMousePosition = false;
    var domTT_trail = true;
    var domTT_activateDelay = 0;
    var domTT_onePopup = true;
    var domTT_direction = 'southeast';
    var domTT_offsetX = domLib_isIE ? -2 : 0;
    var domTT_mouseHeight = domLib_isIE ? 17 : 19;
  </script>
  <?php
}
//******************************************************************************
function getConfig()
{
  global $config;
  $cfg_path = realpath(__DIR__ . "/../../configs/") . DIRECTORY_SEPARATOR;
  // Ensure the configuration directory exists
  if ($cfg_path === false || !is_dir($cfg_path)) {
    throw new RuntimeException("Configuration directory not found.");
  }
  $default_config = "cfg-default.php";
  if (isset($_GET['config'])) {
    $requested_file = basename($_GET['config']); // Strip path traversal characters
    // Validate extension
    if (pathinfo($requested_file, PATHINFO_EXTENSION) !== "php") {
      return "{$cfg_path}{$default_config}";
    }
    // Validate against whitelist
    $allowed_files = ["cfg-default.php", "cfg-custom.php", "cfg-advanced.php"];
    if (!in_array($requested_file, $allowed_files, true)) {
      return "{$cfg_path}{$default_config}";
    }
    // Resolve real path and check containment
    $real_cfg_path = realpath($cfg_path . $requested_file);
    if ($real_cfg_path === false || strpos($real_cfg_path, $cfg_path) !== 0) {
      return "{$cfg_path}{$default_config}";
    }
    // Final file existence check
    if (is_file($real_cfg_path)) {
      $config = $requested_file;
      return $real_cfg_path;
    }
  }
  // Fallback to default if all validations fail
  $config = $default_config;
  return "{$cfg_path}{$default_config}";
}
//******************************************************************************
function setSkin()
{
  $cookie_expire_time = time() + 60 * 60 * 24 * 30 * 12;
  global $skin, $skin_data, $stylesheet;
  ob_start();
  if (!$GLOBALS['settings']['display']['skin_selector']) {
    $skin = $GLOBALS['settings']['display']['default_skin'];
  } elseif (isset($_GET['skin'])) {
    $skin = $_GET['skin'];
    setcookie('vsp_skin', $_GET['skin'], $cookie_expire_time);
  } elseif (!isset($_COOKIE['vsp_skin'])) {
    setcookie('vsp_skin', $GLOBALS['settings']['display']['default_skin'], $cookie_expire_time);
    $skin = $GLOBALS['settings']['display']['default_skin'];
  } else {
    $skin = $_COOKIE['vsp_skin'];
  }
  if (strlen($skin) < 1) {
    $skin = $GLOBALS['settings']['display']['default_skin'];
  }
  $stylesheet = "./skins/$skin/$skin.css";
  $fp_skin = fopen($stylesheet, "rb");
  if (!$fp_skin) {
    if ($skin == $GLOBALS['settings']['display']['default_skin']) {
      ob_end_flush();
      print("<html><head></head><body>ERROR: Default skin \"$stylesheet\" not found!</body></html>");
    } else {
      setcookie('vsp_skin', $GLOBALS['settings']['display']['default_skin'], $cookie_expire_time);
      ob_end_flush(); ?>
      <html>
        <head> </head>
        <body>
          <script>
            window.location = "<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]";
                              if (isset($_GET['sort'])) {
                                print "&amp;sort = $_GET[sort]";
                              } ?>"
          </script>
        </body>
      </html>
  <?php
    }
    exit();
  } else {
    ob_end_flush();
    $line = fgets($fp_skin, 255);
    fclose($fp_skin);
    $skin_data['name'] = $skin;
    if (preg_match('/<author>(.*)<\/author>/i', $line, $regs)) {
      $skin_data['author'] = $regs[1];
    } elseif (!isset($skin_author_name) || strlen($skin_author_name) <= 0) {
      $skin_data['author'] = "anon";
    }
    if (preg_match('/<email>(.*)<\/email>/i', $line, $regs)) {
      $skin_data['email'] = $regs[1];
    } else {
      $skin_data['email'] = "";
    }
  }
}
//******************************************************************************
function drawMainHeading()
{
  ?>
  <table class="vspmain" width="100%">
    <?php if (!empty($GLOBALS['cfg']['display']['server_info'])): ?>
    <tr>
      <td width="100%" class="cellHeading" style="text-align: center" colspan="3"><?php print $GLOBALS['cfg']['display']['server_title']; ?></td>
    </tr>
    <tr>
      <td class="cell1" style="text-align: center"><a href="https://www.krillinsworld.com">
        <img alt="Krillin's World Logo" height="75" width="200" style="padding: 2px 0 0 0;border-radius:5px;" src="<?php print $GLOBALS['cfg']['display']['server_image']; ?>"></a></td>
      <td class="cell1" width="100%" style="text-align: left">
        <?php print $GLOBALS['cfg']['display']['server_info']; ?> </td>
      <td class="cell1" style="text-align: center"><a href="https://www.krillinsworld.com/vsp/">
        <img alt="VSP™ Logo" height="75" width="75" style="padding: 2px 0 0 0;border-radius:5px;" src="<?php print $GLOBALS['cfg']['display']['v_logo']; ?>"></a></td>
    </tr>
    <?php endif; ?>
  </table>
<?php
}
//******************************************************************************
function drawMenu()
{
?>
  <table class="vsppadding1" style="border-width:0;border:0" width="100%">
    <tr>
      <td height="20" width="12.5%" class="cellSubHeading" style="text-align: center; font-size: larger"><a href="index.php?config=<?php print $GLOBALS['config']; ?>">Main Stats</a></td>

      <?php
      if ($GLOBALS['settings']['display']['gamestats']) {
      ?>
      <td width="12.5%" class="cellSubHeading" style="text-align: center; font-size: larger"><a href="gamestat.php?config=<?php print $GLOBALS['config']; ?>">Game Stats</a></td>
      <?php } ?>

      <td width="12.5%" class="cellSubHeading" style="text-align: center; font-size: larger"><a href="awardstat.php?config=<?php print $GLOBALS['config']; ?>">Award Stats</a></td>
      <!--<td width="12.5%" class="cellSubHeading" style="text-align: center">Server Stats</td>-->
      <!--<td width="12.5%" class="cellSubHeading" style="text-align: center">Violations</td>-->
      <td width="12.5%" class="cellSubHeading" style="text-align: center; font-size: larger"><a href="https://krillinsworld.com/forum/index.php/board,30.0.html">F.A.Q.</a></td>



      <?php
      if ($GLOBALS['settings']['display']['skin_selector']) {
        if ($handle = opendir('./skins')) {
          while (false !== ($file = readdir($handle))) {
            if (!preg_match("/^\\./", $file)) {
              $skin_file[] = $file;
            }
          }
          closedir($handle);
        } ?>

        <?php
        if (count($skin_file) > 1) {
          asort($skin_file); ?>
          <td width="12.5%" class="cellSubHeading" style="text-align: center; font-size: larger">
            <b>Skins:</b>
            <form style="display: inline" method="post" action="<?php print "$_SERVER[PHP_SELF]"; ?>">

              <?php
              $query_str = $_SERVER['QUERY_STRING'];
              $query_str = preg_replace("/&amp;skin=[^&]*/i", '', $query_str); ?>

              <select style="text-align:center;" name="skin_select" size="1" class="cellSubHeading" OnChange="location.href='<?php print $_SERVER['PHP_SELF'] . "?" . htmlentities(preg_replace("/&skin=[^&]+/", "", $query_str)) . "&amp;skin="; ?>'+form.skin_select.options[form.skin_select.selectedIndex].value">
                <?php
                foreach ($skin_file as $num => $file) {
                ?>
                <option <?php if ($GLOBALS['skin'] == $file) { echo "selected"; } ?> style="text-align: center" class="cellSubHeading" value="<?php echo $file; ?>"><?php echo $file; ?></option>
                <?php } ?>
              </select>
            </form>
          </td>
      <?php
        }
      } ?>

    </tr>
  </table>
<?php
}
//******************************************************************************
function drawCredits()
{
  global $db, $skin_data;
  // If no value found for the Last Updated Time in the DB
  $sql = "SELECT value
          FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata
          WHERE name=" . $db->qstr("Last updated time");
  $rs = $db->Execute($sql);
  $last_update_time = ($rs && !$rs->EOF) ? $rs->fields[0] : "&thinsp;?";
  $rs = '';

  // If no value for VSP™ version found in the DB
  $sql = "SELECT value
          FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata
          WHERE name=" . $db->qstr("VSP Version");
  $rs = $db->Execute($sql);
  $vsp_version = ($rs && !$rs->EOF) ? $rs->fields[0] : "&thinsp;?";
  ?>
  <!-- credits   table begin ##################################################-->
  <table class="cellHeading vsppadding2" width="100%">
    <tr>
      <td colspan="3" width="30%" class="cellHeading" style="text-align:center">
        Powered by <a href="https://www.krillinsworld.com/vsp/">Voodoo Stats Processor&thinsp;</a> 
        &copy; 2004&thinsp;-&thinsp;<?php echo date("Y"); ?>&nbsp;By&nbsp;
        <a href="#" title="krillinsworld <aT> gmail <DOT> com">Krillin&thinsp;|&thinsp;myrdd1n</a>&ensp;
      </td>
    </tr>

    <tr>
      <td width="35%" class="cellSubHeading" style="text-align: left; border-right-width: 0">&ensp;<?php print "Theme: Bismarck by <a href=\"#\" title=\"myrddin8 <aT> gmail <DOT> com\">myrdd1n</a>"; ?>&ensp;</td>
      <td width="30%" class="cellSubHeading" style="text-align: center; border-right-width: 0; border-left-width: 0">&ensp;<a href="https://www.krillinsworld.com/vsp/">VSP™&thinsp;Version:&thinsp;<?php print $vsp_version; ?></a>&ensp;—&ensp;Last Updated: <?php print $last_update_time; ?></td>
      <td width="35%" class="cellSubHeading" style="text-align: right; border-left-width: 0">&ensp;<?php print "Skin: $skin_data[name] by: <a href=\"#\" title=\"$skin_data[email]\">$skin_data[author]</a>"; ?>&ensp;</td>
    </tr>

    <tr>
      <td colspan="3" width="100%">
        <?php
          $elapsed = timeElapsed($start_time);
          ob_end_flush(); // flush after compactHTML
          echo "<div class='pageloaded'>Page loaded in " . $elapsed['seconds'] . "s (" . $elapsed['milliseconds'] . "ms)</div>";
        ?>
      </td>
    </tr>
  </table>
  <!-- credits   table end   ##################################################-->
<?php
}
//******************************************************************************

?>