<?php
$start_time = gettimeofday();

define('IN_VSP', true);
require "./util.php";
require "./all.inc.php";
require getConfig();
require "{$GLOBALS['cfg']['db']['adodb_path']}".'adodb.inc.php';

$db = ADONewConnection("{$GLOBALS['cfg']['db']['adodb_driver']}");
if (!$db->Connect($GLOBALS['cfg']['db']['hostname'], $GLOBALS['cfg']['db']['username'], $GLOBALS['cfg']['db']['password'], $GLOBALS['cfg']['db']['dbname'])) {
  print "Error: cannot establish database connection\n";
  exit();
}
$db->SetFetchMode(ADODB_FETCH_NUM);
$playerID = $_GET['playerID'];

$playerID = stripslashes($playerID);

$qplayerID = $db->qstr($playerID);

setSkin();
setupVars();
getStats();
getStats1D();
readPlayerData();

?>

<!DOCTYPE html>
<html lang="en-US" dir="ltr">
<head>
<meta charset="utf-8">
<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
<link rel="manifest" href="favicon/site.webmanifest">
<link rel="stylesheet" href="css/style.css" type="text/css">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<title>VSP™ (player stats)</title>
<link rel=stylesheet href="<?php print $GLOBALS['stylesheet']; ?>" type="text/css">
<?php if ($settings['display']['javascript_tooltips']) {
    includeDOMTT();
} ?>
<script language="javascript" type="text/javascript" src="../../lib/sorttable/sorttable.js"></script>
<script language="JavaScript" type="text/javascript">

function searchByGUID(search_txt)
{
  document.guidform.search_txt.value=''+search_txt;
  document.guidform.submit();
}
function searchByIP(search_txt)
{
  document.ipform.search_txt.value=''+search_txt;
  document.ipform.submit();
}
function searchByName(search_txt)
{
  document.nameform.search_txt.value=''+search_txt;
  document.nameform.submit();
}
</script>
</head>

<?php
$pre_time = timeElapsed($start_time);
ob_start("compactHTML");
?>

<body>

<?php
//*************************************************************************
function setupVars()
{
  if (!is_dir("../../games/{$GLOBALS['cfg']['game']['name']}")) {
    $GLOBALS['cfg']['game']['name'] = 'default';
  }
}
//*************************************************************************
function drawHeadBar()
{
  global $sort,$config; ?>
  <!-- navbar begin          ################################################-->
  <table class="cellHeading,vsppadding1" width="100%" style="border-width: 0px;">
    <tr>
      <td height="25" class="cellHeading" style="border-right-width: 0px; text-align: left;" >
        <b>Player Profile</b>
      </td>
    </tr>
  </table>
  <!-- navbar end            ################################################-->
  <?php
}
//*************************************************************************
function drawStats1D($eventCategory)
{
  global $db,$gmatrix1D,$gevent1D,$geventName1D;
  
  $gevent1D_tmp = $gevent1D;
  
  $max_items = 0;
  foreach ($gevent1D_tmp as $eventCat => $val) {
    $max_new = count($val);
    if ($max_new>$max_items) {
      $max_items = $max_new;
    }
  } ?>
  <!-- events per category begin ##################################################-->
  <table class="vspmain" style="border-width: 0" width="100%" >
  <tr class="cellSubHeading">
    <td colspan="2" width="100%" style="text-align: left"><?php print fstr($eventCategory); ?>&nbsp;</td>
  </tr>
  <?php
  $count = 0;
    if (isset($gmatrix1D[$eventCategory]) && is_array($gmatrix1D[$eventCategory])) {
      foreach ($gmatrix1D[$eventCategory] as $eventName => $eventValue) {
        if ($count % 2 == 0) {
          $cell_class = "cell1";
        } else {
          $cell_class = "cell2";
        }
        $count++; ?>
      <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
      <td width="70%" style="text-align: left"><?php print fstr($eventName); ?></td>
      <td width="30%"><?php print fstr($eventValue); ?></td>
      </tr>
      <?php
      }
    }
  
    for ($i = $count; $i < $max_items; $i++) {
        if ($i % 2 == 0) {
            $cell_class = "cell1";
        } else {
            $cell_class = "cell2";
        } ?>
    <tr class="<?php print "$cell_class"?>">
    <td width="70%">&nbsp;</td>
    <td width="30%">&nbsp;</td>
    </tr>
    <?php
    } ?>
  </table>
  <!-- events per category end   ##################################################-->
  <?php
}
//*************************************************************************
function drawPlayerStats()
{
  $categories_per_row = 3;
  global $db,$gmatrix1D,$gevent1D,$gmatrix,$gmatrixtotal,$gweapon,$player_data; ?>

  <table class="vspmain" style="border-width: 0; padding: 0" width="100%">
    <tr>
      <td colspan="<?php print $categories_per_row; ?>" width="100%" class="cellHeading" style="text-align: left">
        &nbsp;
      </td>
    </tr>



      <?php
      $count_cat = 0;
      
    if (isset($gevent1D)) {
        foreach ($gevent1D as $eventCategory => $val) {
            if ($count_cat%$categories_per_row == 0) {
                echo "\n<tr>";
            }

            $count_cat++; ?>
          <td width="<?php print round(100/$categories_per_row, 2)?>%" class="cellBG" style="vertical-align: top; text-align: left ;border-width: 0px; padding: 0px;">
          <?php drawStats1D($eventCategory); ?>
          </td>
          <?php

          if ($count_cat % $categories_per_row == 0) {
              echo "</tr>\n";
          }
        }
    }

    while ($count_cat % $categories_per_row != 0) {
        if ($count_cat % $categories_per_row == 0) {
            echo "\n<tr>";
        }

        $count_cat++; ?>
        <td width="<?php print 100/($categories_per_row)?>%" class="cellSubHeading" style="vertical-align: top; text-align: left ;border-width: 0px; padding: 0px;">
        <?php drawStats1D(false); ?>
        </td>
        <?php

        if ($count_cat % $categories_per_row == 0) {
            echo "</tr>\n";
        }
    } ?>

      <tr>
        <td colspan="<?php print $categories_per_row; ?>" width="100%" class="cellSubHeading" style="vertical-align: top; text-align: left; padding: 0px; border-width: 0px;">
        <?php drawWeaponStats(); ?>
        </td>
      </tr>


      </table>
      <br>

  <?php
}

//*************************************************************************
function getStats1D()
{
  global $db,$gmatrix1D,$gevent1D,$gicon;
  $sql = "SELECT eventCategory, eventName, sum(eventValue),team,role  
          FROM {$GLOBALS['cfg']['db']['table_prefix']}eventdata1d
          WHERE playerID={$GLOBALS['qplayerID']}
          GROUP BY playerID,eventCategory,eventName,team,role
        ";

  //echo $sql;
  $rs = $db->Execute($sql);

  if ($rs && !$rs->EOF) {
    do {
      if ($rs->fields[0] == 'icon') {
        if (!isset($gicon[$GLOBALS['playerID']][$rs->fields[3]][$rs->fields[4]][$rs->fields[1]])) {
          $gicon[$GLOBALS['playerID']][$rs->fields[3]][$rs->fields[4]][$rs->fields[1]] = 0;
        }
        $gicon[$GLOBALS['playerID']][$rs->fields[3]][$rs->fields[4]][$rs->fields[1]] += $rs->fields[2];
      } else {
        $gevent1D[$rs->fields[0]][$rs->fields[1]] = 1;

        if (!isset($gmatrix1D[$rs->fields[0]][$rs->fields[1]])) {
          $gmatrix1D[$rs->fields[0]][$rs->fields[1]] = 0;
        }
        $gmatrix1D[$rs->fields[0]][$rs->fields[1]] += $rs->fields[2];
      }
    } while ($rs->MoveNext());
  }

  if ($gevent1D) {
    ksort($gevent1D);
    foreach ($gevent1D as $cat => $event) {
      ksort($gevent1D[$cat]);
    }
  }
  if ($gmatrix1D) {
    foreach ($gmatrix1D as $eventCategoryi => $eventCategoryi_val) {
      ksort($gmatrix1D[$eventCategoryi]);
    }
  }
}
//*************************************************************************
function getStats()
{
  global $db,$gevent1D,$gmatrix1D,$gmatrix,$gmatrixtotal,$gweapon,$gplayerName,$ggame;
  $sql = "SELECT eventCategory, team, team2, ED2D.playerID, player2ID, eventName, eventValue, playerName,gameID,ED2D.role,ED2D.role2  
          FROM {$GLOBALS['cfg']['db']['table_prefix']}eventdata2d as ED2D,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP
          WHERE ED2D.playerID={$GLOBALS['qplayerID']}
          AND ED2D.playerID!=ED2D.player2ID
          AND ED2D.player2ID=PP.playerID
         ";

  //echo($sql);
  $rs_all[] = $db->Execute($sql);
  
  $sql = "SELECT eventCategory, team, team2, ED2D.playerID, player2ID, eventName, eventValue, playerName,gameID,ED2D.role,ED2D.role2  
          FROM {$GLOBALS['cfg']['db']['table_prefix']}eventdata2d as ED2D,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP
          WHERE ED2D.player2ID={$GLOBALS['qplayerID']}
          AND ED2D.playerID=PP.playerID
         ";

  //echo($sql);
  $rs_all[] = $db->Execute($sql);

  foreach ($rs_all as $rs_count => $rs) {
    if ($rs && !$rs->EOF) {
      do {
        $ggame[$rs->fields[8]] = 1;
        if ($rs->fields[0] == 'kill' || $rs->fields[0] == 'suicide' || $rs->fields[0] == 'teamkill') {
          $gweapon[$rs->fields[5]] = 1;

          if ($rs_count == 0) {
            $gplayerName[$rs->fields[4]] = $rs->fields[7];
          } elseif ($rs_count == 1) {
            $gplayerName[$rs->fields[3]] = $rs->fields[7];
          }

          if (!strcmp($rs->fields[3], $GLOBALS['playerID']) && $rs->fields[0] == 'kill') { 
            if (!isset($gmatrixtotal[$rs->fields[4]]['_v_weapon']['kills'])) {
              $gmatrixtotal[$rs->fields[4]]['_v_weapon']['kills'] = 0;
            }
            $gmatrixtotal[$rs->fields[4]]['_v_weapon']['kills'] += $rs->fields[6];

            if (!isset($gmatrixtotal['_v_player'][$rs->fields[5]]['kills'])) {
              $gmatrixtotal['_v_player'][$rs->fields[5]]['kills'] = 0;
            }
            $gmatrixtotal['_v_player'][$rs->fields[5]]['kills'] += $rs->fields[6];

            if (!isset($gmatrixtotal['_v_player']['_v_weapon']['kills'])) {
              $gmatrixtotal['_v_player']['_v_weapon']['kills'] = 0;
            }
            $gmatrixtotal['_v_player']['_v_weapon']['kills'] += $rs->fields[6];

        } elseif (!strcmp($rs->fields[3], $GLOBALS['playerID']) && $rs->fields[0] == 'suicide') {

          if (!isset($gmatrixtotal['_v_player'][$rs->fields[5]]['suicides'])) {
            $gmatrixtotal['_v_player'][$rs->fields[5]]['suicides'] = 0;
          }
          $gmatrixtotal['_v_player'][$rs->fields[5]]['suicides'] += $rs->fields[6];

          if (!isset($gmatrixtotal['_v_player']['_v_weapon']['suicides'])) {
            $gmatrixtotal['_v_player']['_v_weapon']['suicides'] = 0;
          }
          $gmatrixtotal['_v_player']['_v_weapon']['suicides'] += $rs->fields[6];

          if (!isset($gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'])) {
            $gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'] = 0;
          }
          $gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'] += $rs->fields[6];

          if (!isset($gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'])) {
            $gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'] = 0;
          }
          $gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'] += $rs->fields[6];

          if (!isset($gmatrixtotal['_v_player']['_v_weapon']['deaths'])) {
            $gmatrixtotal['_v_player']['_v_weapon']['deaths'] = 0;
          }
          $gmatrixtotal['_v_player']['_v_weapon']['deaths'] += $rs->fields[6];

          } elseif (!strcmp($rs->fields[3], $GLOBALS['playerID']) && $rs->fields[0] == 'teamkill') {

            $gevent1D['']['Team Kills'] = 1;
              if (!isset($gmatrix1D['']['Team Kills'])) {
                $gmatrix1D['']['Team Kills'] = 0;
              }
              $gmatrix1D['']['Team Kills'] += $rs->fields[6];
          } elseif (!strcmp($rs->fields[4], $GLOBALS['playerID']) && $rs->fields[0] == 'teamkill') {
            
            $gevent1D['']['Team Deaths'] = 1;
            if (!isset($gmatrix1D['']['Team Deaths'])) {
              $gmatrix1D['']['Team Deaths'] = 0;
            }
            $gmatrix1D['']['Team Deaths'] += $rs->fields[6];

            /*
            // If this code is enabled, it messes with the easiest prey/worst enemy stuff.
            // ie team kills get shown in the easiest prey column
            if (!isset($gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths']))
              $gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'] = 0;
            $gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'] += $rs->fields[6];
            */

            if (!isset($gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'])) {
              $gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'] = 0;
            }
            $gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'] += $rs->fields[6];

            if (!isset($gmatrixtotal['_v_player']['_v_weapon']['deaths'])) {
              $gmatrixtotal['_v_player']['_v_weapon']['deaths'] = 0;
            }
            $gmatrixtotal['_v_player']['_v_weapon']['deaths'] += $rs->fields[6];

          } else {

            if (!isset($gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'])) {
              $gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'] = 0;
            }
            $gmatrixtotal[$rs->fields[3]]['_v_weapon']['deaths'] += $rs->fields[6];

            if (!isset($gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'])) {
              $gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'] = 0;
            }
            $gmatrixtotal['_v_player'][$rs->fields[5]]['deaths'] += $rs->fields[6];

            if (!isset($gmatrixtotal['_v_player']['_v_weapon']['deaths'])) {
              $gmatrixtotal['_v_player']['_v_weapon']['deaths'] = 0;
            }
            $gmatrixtotal['_v_player']['_v_weapon']['deaths'] += $rs->fields[6];
          }

        } elseif ($rs->fields[0] == 'accuracy') {
          if (preg_match("/^(.*)_(.*)/", $rs->fields[5], $ma)) {
            $weapon = $ma[1];
            $type = $ma[2];

            if (!isset($gweapon[$weapon])) {
              $gweapon[$weapon] = 1;
            }

            if ($type == 'hits') {
              if (!strcmp($rs->fields[3], $rs->fields[4])) {
                if (!isset($GLOBALS['g_hitbox']['ALL'])) {
                  $GLOBALS['g_hitbox']['ALL'] = 0;
                }
                $GLOBALS['g_hitbox']['ALL'] += $rs->fields[6];

                if (!isset($gmatrixtotal['_v_player'][$weapon]['hits'])) {
                 $gmatrixtotal['_v_player'][$weapon]['hits'] = 0;
                }
                $gmatrixtotal['_v_player'][$weapon]['hits'] += $rs->fields[6];

                if (!isset($gmatrixtotal['_v_player']['_v_weapon']['hits'])) {
                  $gmatrixtotal['_v_player']['_v_weapon']['hits'] = 0;
                }
                $gmatrixtotal['_v_player']['_v_weapon']['hits'] += $rs->fields[6];
              }
            
            } elseif ($type == 'shots') {
              if (!strcmp($rs->fields[3], $rs->fields[4])) {
                if (!isset($gmatrixtotal['_v_player'][$weapon]['shots'])) {
                  $gmatrixtotal['_v_player'][$weapon]['shots'] = 0;
                }
                $gmatrixtotal['_v_player'][$weapon]['shots'] += $rs->fields[6];

                if (!isset($gmatrixtotal['_v_player']['_v_weapon']['shots'])) {
                  $gmatrixtotal['_v_player']['_v_weapon']['shots'] = 0;
                }
                $gmatrixtotal['_v_player']['_v_weapon']['shots'] += $rs->fields[6];
              }
            } elseif (preg_match("/loc(.+)/", $type, $ma)) {
              if (!isset($GLOBALS['g_hitbox'][$ma[1]])) {
                $GLOBALS['g_hitbox'][$ma[1]] = 0;
              }
              $GLOBALS['g_hitbox'][$ma[1]] += $rs->fields[6];
            }
          }
        } else {
          // PvP events. Just add as normal 1D event for now
          $gevent1D[$rs->fields[0]][$rs->fields[5]] = 1;
          if (!isset($gmatrix1D[$rs->fields[0]][$rs->fields[5]])) {
            $gmatrix1D[$rs->fields[0]][$rs->fields[5]] = 0;
          }
          $gmatrix1D[$rs->fields[0]][$rs->fields[5]] += $rs->fields[6];
        }
      } while ($rs->MoveNext());
    }
  }

  ksort($gweapon);

}
//*************************************************************************
function drawPreyOrEnemyList($what, $limit)
{
  global $db,$gmatrixtotal,$gplayerName;

  if (!strcmp($what, "prey")) {
    $eff_sortdir = "down";
    $data = 'kills';
    $table_heading = "Easiest Preys";
  } elseif (!strcmp($what, "enemy")) {
    $eff_sortdir = "up";
    $data = 'deaths';
    $table_heading = "Worst Enemies";
  } else {
    return;
  }

  foreach ($gmatrixtotal as $player_i => $val_i) {
    if (isset($gmatrixtotal[$player_i]['_v_weapon'][$data])) {
      $player_list[$player_i] = $gmatrixtotal[$player_i]['_v_weapon'][$data];
    }
  }

  unset($player_list['_v_player']);
  unset($player_list[$GLOBALS['playerID']]);

  arsort($player_list, SORT_NUMERIC); ?>
  <!-- prey/enemy  table begin ##################################################-->
  <table class="vsppadding2" style="border-width: 0" width="100%">
    <tr>
    <td width="100%" colspan="5" class="cellHeading" style="text-align: center "><?php echo $table_heading?> (top <?php echo $limit?>)  
    </td>
    </tr>
  </table>
  <table class="vsppadding2" style="border-width: 0" width="100%" class="sortable" id="<?php echo $what?>">
    <tr class="cellSubHeading">
    <td style="text-align: left">Player</td>
    <td>Kills</td>
    <td>Deaths</td>
    <td sortdir="<?php print $eff_sortdir; ?>">Eff %</td>
    </tr>
  <?php

  $count = 0;
    foreach ($player_list as $playerID=>$val) {
        $count++;
        if ($count%2 == 1) {
            $cell_class = "cell1";
        } else {
            $cell_class = "cell2";
        }
        $kills = $gmatrixtotal[$playerID]['_v_weapon']['kills'] ?? 0;
        $deaths = $gmatrixtotal[$playerID]['_v_weapon']['deaths'] ?? 0;
        ?>
    <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >
    <td style="text-align: left">
    <a href="playerstat.php?playerID=<?php print rawurlencode($playerID)."&amp;config=$GLOBALS[config]"; ?>">
    <?php print processColors(htmlspecialchars($gplayerName[$playerID]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length']); ?>
    </a>
    </td>
    <td><?php print $kills?></td>
    <td><?php print $deaths; ?></td>
    <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>
    </tr>
    <?php
    if ($count == $limit) {
      break;
    }
    } ?>
  </table>
  <!-- prey/enemy  table end ##################################################-->
  <?php
}
//*************************************************************************
function drawPlayerAwards()
{
  global $db,$award_image;

  $sql = "SELECT awardID,name,category,image,playerName,{$GLOBALS['cfg']['db']['table_prefix']}awards.playerID 
    FROM {$GLOBALS['cfg']['db']['table_prefix']}awards,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile
    WHERE {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['qplayerID']}
    AND {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['cfg']['db']['table_prefix']}playerprofile.playerID
    ORDER BY category,name
    ";
  
  $rs = $db->Execute($sql);

  if ($rs && !$rs->EOF) {
    ?>
    <!-- allawards table begin ##################################################-->
    <table class="vsppadding2" style="border-width: 0" width="100%">
    <tr>
      <td colspan="3" width="100%"  class="cellHeading" style="text-align: left">Awards List</td>
    </tr>
    <?php
    do {
      ?>
      <tr class="cellSubHeading">
        <td colspan="3" width="100%" style="text-align: left;"><?php print $rs->fields[2]; ?></td>
      </tr>    
      <?php
      $count = 0;
      do {
        $count++;
        if ($count%2 == 1) {
          $cell_class = "cell1";
        } else {
          $cell_class = "cell2";
        }
        $cat = $rs->fields[2];

        $award_images[] = "";
        unset($award_images);
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}".".webp";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}".".jpg";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}".".png";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.webp";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.jpg";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.png";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/default/default.webp";
        $award_images[] = "../../games/default/awardsets/default/default.webp";

        $no_of_award_images = count($award_images);
        for ($i = 0; $i < $no_of_award_images; $i++) {
          if (is_file($award_images[$i])) {
            $award_image = $award_images[$i];
            break;
          }
        }

        /*
        $award_image = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[3]}";
        //echo $award_image;
        if (!is_file($award_image))
        {
          $award_image = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.gif";
        }
        */ 
        ?>
        <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
          <td style="text-align: left" width="100%">
            <a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>">
            <?php print processColors(htmlspecialchars($rs->fields[1]), $GLOBALS['settings']['display']['color_names'], 0); ?>
            </a>
          </td>

          <td style="text-align: center;">
            <a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>">
            <img alt="" name="<?php print "AWARD_".$rs->fields[0]; ?>" src="<?php print $award_image; ?>"></a>
          </td>
          
        </tr>
        <?php
        } while ($rs->MoveNext()  && strcmp($cat, $rs->fields[2]) == 0);
    } while (!$rs->EOF); ?>
    </table>
    <!-- allawards table end ##################################################-->
    <br>
    <?php
  }
}
//*************************************************************************
function drawPlayerAwardsCompact()
{
  global $db,$award_image;

  $sql = "SELECT name,image,playerName,category,{$GLOBALS['cfg']['db']['table_prefix']}awards.playerID,awardID 
    FROM {$GLOBALS['cfg']['db']['table_prefix']}awards,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile
    WHERE {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['qplayerID']}
    AND {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['cfg']['db']['table_prefix']}playerprofile.playerID
    ORDER BY category,name
    ";
  $rs = $db->Execute($sql);

  if ($rs && !$rs->EOF) {
    ?>
  <!-- awards    table begin ##################################################-->
  <table class="vsppadding2" style="border-width: 0;" width="100%">
  <tr>
    <td colspan="2" width="100%"  class="cellHeading" style="padding: 2px; text-align: center;">Awards List</td>
  </tr>

  <?php
  do {
      ?>
    <tr>
      <td colspan="2" width="100%"  class="cellSubHeading" style="text-align: center;"><?php print $rs->fields[3]; ?></td>
    </tr>    
    <?php
    $count = 0;
      $count_per_cat = 0;
      do {
        if ($count%2 == 0) {
          $cell_class = "cell1";
        } else {
          $cell_class = "cell2";
        }

        $cat = $rs->fields[3];

        $award_images[] = "";
        unset($award_images);
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".webp";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".jpg";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".png";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.webp";
        $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/default/default.webp";
        $award_images[] = "../../games/default/awardsets/default/default.webp";

        $no_of_award_images = count($award_images);
        for ($i = 0; $i < $no_of_award_images; $i++) {
          if (is_file($award_images[$i])) {
            $award_image = $award_images[$i];
            break;
          }
        }

        if ($count_per_cat % $GLOBALS['settings']['display']['playerstats_max_awards_per_line'] == 0) {
          if ($count_per_cat > 0) {
            ?>
            &nbsp;
            </td>
            </tr>
            <?php
          }
          $count++; ?>
          <tr class="<?php print "$cell_class"?>">
          <td style="text-align: center;">
          <?php
          } ?>

          <a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[5])."&amp;config=$GLOBALS[config]"; ?>"><img style="float:right" alt="" name="<?php print "AWARD_".$rs->fields[5]; ?>" class="tooltip" title="<?php print $rs->fields[0]; ?>" src="<?php print $award_image; ?>"></a>
          <?php

          $count_per_cat++;
      } while ($rs->MoveNext() && strcmp($cat, $rs->fields[3]) == 0);

      if ($count_per_cat>0) {
        ?>
        &nbsp;
        </td>
        </tr>
        <?php
      }
    } while (!$rs->EOF); ?>
    </table>
    <!-- awards    table end ##################################################-->
  <?php
  }
}
//*************************************************************************
function drawPlayerAwardsSimple()
{
  global $db,$award_image;

  $sql = "SELECT name,image,playerName,category,{$GLOBALS['cfg']['db']['table_prefix']}awards.playerID,awardID 
    FROM {$GLOBALS['cfg']['db']['table_prefix']}awards,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile
    WHERE {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['qplayerID']}
    AND {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['cfg']['db']['table_prefix']}playerprofile.playerID
    ORDER BY category,name
    ";
  $rs = $db->Execute($sql);
  
  if ($rs && !$rs->EOF) {
    ?>Awards: <?php
  do {
    $cat = $rs->fields[3];

    $award_images[] = "";
    unset($award_images);
    $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".webp";
    $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".jpg";
    $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".png";
    $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.webp";
    $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/default/default.webp";
    $award_images[] = "../../games/default/awardsets/default/default.webp";

    $no_of_award_images = count($award_images);
    for ($i = 0; $i < $no_of_award_images; $i++) {
      if (is_file($award_images[$i])) {
        $award_image = $award_images[$i];
        break;
      }
    } ?>
    <a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[5])."&amp;config=$GLOBALS[config]"; ?>"><img style="float:right" alt="" name="<?php print "AWARD_".$rs->fields[5]; ?>" title="<?php print $rs->fields[0]." ($cat)"; ?>" src="<?php print $award_image; ?>"></a>
    <?php
    } while ($rs->MoveNext() && !$rs->EOF);
  }
}
//*************************************************************************
function drawPlayerGUIDs()
{
  ?>
  <!-- guid      table begin ##################################################-->
  <form name="guidform" action="index.php?config=<?php print $GLOBALS['config']; ?>" method="post">
  <input type='hidden' name='search_by' value='guid'>
  <input type='hidden' name='search_txt' value=''>
  <table class="vsppadding2" style="border-width: 0" width="100%">
  <tr>
    <td colspan="2" width="100%"  class="cellHeading" style="text-align: center;">GUIDs</td>
  </tr>
  <?php

  global $db;
  
  $sql = "SELECT dataValue,count(*)
    FROM {$GLOBALS['cfg']['db']['table_prefix']}playerdata 
    WHERE playerID={$GLOBALS['qplayerID']} 
    AND gameID!=0
    AND dataName='guid'
    GROUP BY dataValue
    ORDER BY dataValue ASC
    ";
  
    $rs = $db->Execute($sql);

    if ($rs && !$rs->EOF) {
      $count = 0;
      do {
        $count++;
        if ($count%2 == 1) {
          $cell_class = "cell1";
        } else {
          $cell_class = "cell2";
        }

        if ((strlen($rs->fields[0])>20)) {
          $guid_display = substr($rs->fields[0], $GLOBALS['settings']['display']['playerstats_guid_start'], $GLOBALS['settings']['display']['playerstats_guid_length']);
        } else {
          $guid_display = $rs->fields[0];
        } ?>
        <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
        <td style="text-align: left"><a href="javascript:searchByGUID('<?php print $rs->fields[0]; ?>');" title="<?php print $rs->fields[0]; ?>"><?php print $guid_display?></a></td>
        <td><?php print fstr($rs->fields[1]); ?></td>
      </tr>
      <?php
        } while ($rs->MoveNext());
    } ?>
  </table>
  </form> 
  <!-- guid      table end ##################################################-->
  <?php
}
//*************************************************************************
function drawPlayerIPs()
{
    ?>
  <!-- ip        table begin ##################################################-->
  <form name="ipform" action="index.php?config=<?php print $GLOBALS['config']; ?>" method="post">
  <input type='hidden' name='search_by' value='ip'>
  <input type='hidden' name='search_txt' value=''>
  <table class="vsppadding2" style="border-width: 0;" width="100%">
  <tr>
    <td colspan="2" width="100%"  class="cellHeading" style="text-align: center;">IPs</td>
  </tr>
  
  <?php

  global $db;
  
  $sql = "SELECT dataValue,count(*)
    FROM {$GLOBALS['cfg']['db']['table_prefix']}playerdata 
    WHERE playerID={$GLOBALS['qplayerID']} 
    AND gameID!=0
    AND dataName='ip'
    GROUP BY dataValue
    ORDER BY dataValue ASC";
  
    $rs = $db->Execute($sql);
  
    if ($rs && !$rs->EOF) {
      $count = 0;
      do {
        $count++;
        if ($count % 2 == 1) {
          $cell_class = "cell1";
        } else {
          $cell_class = "cell2";
        }

        preg_match("/(\d+\\.\d+\\.)\d+\\.\d+/", $rs->fields[0], $ma);
        $ip = $ma[1].'?.?';
        ?>
        <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >
          <td style="text-align: left;"> 
          <a href="javascript:searchByIP('<?php print $ma[1]; ?>');"><?php print $ip; ?></a>
        </td>
        <td><?php print fstr($rs->fields[1]); ?></td>
      </tr>
      <?php
        } while ($rs->MoveNext());
    } ?>
  
  </table>
  </form> 
  <!-- ip        table end ##################################################-->
  <?php
}
//*************************************************************************
function drawPlayerAliases()
{
  global $db; ?>
  <!-- alias     table begin ##################################################-->
  <form name="nameform" action="index.php?config=<?php print $GLOBALS['config']; ?>" method="post">
  <input type='hidden' name='search_by' value='name'>
  <input type='hidden' name='search_txt' value=''>
  <table class="vsppadding2" style="border-width: 0" width="100%">
  <tr>
    <td colspan="2" width="100%"  class="cellHeading" style="text-align: center;">Alias List</td>
  </tr>
  <?php

  $sql = "SELECT dataValue,count(*) as num
    FROM {$GLOBALS['cfg']['db']['table_prefix']}playerdata 
    WHERE playerID={$GLOBALS['qplayerID']} 
    AND gameID!=0
    AND dataName='alias'
    GROUP BY dataValue
    ORDER BY num DESC,dataValue ASC";
  
  $rs = $db->Execute($sql);
  
  if ($rs && !$rs->EOF) {
    $count = 0;
    do {
      $count++;
      if ($count % 2 == 1) {
        $cell_class = "cell1";
      } else {
        $cell_class = "cell2";
      } ?>
      <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
        <td style="text-align: left;">
        <a href="javascript:searchByName('<?php print processColors(addslashes($rs->fields[0]), 0, 0); ?>');"<?php print processColors(htmlspecialchars($rs->fields[0]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length'], 1); ?></a></td>
        <td><?php print($rs->fields[1]); ?></td>
      </tr>
      <?php
        } while ($rs->MoveNext());
    } ?>
  </table>
  </form>
  <!-- alias     table end ##################################################-->
  <?php
}
//*************************************************************************
function drawPlayerData()
{
    global $player_data, $player_data_0, $role_image, $cell_class;
  
    $player_data_0['quote'] = $player_data['quote'];
    $player_data_0['playerName'] = $player_data['playerName'];
    $player_data_0['icon'] = $player_data['icon'];
    $player_data_0['role'] = $player_data['role'];
    $player_data_0['team'] = $player_data['team'];
  
    unset($player_data['quote']);
    unset($player_data['playerName']);
    unset($player_data['icon']);
    unset($player_data['role']);
    unset($player_data['team']);
  
  
    if (is_array($player_data)) {
        ?>
    <!-- playerdatatable begin ##################################################-->
    <table class="vsppadding2" style="border-width: 0" width="100%">
    <tr>
      <td colspan="2" class="cellHeading" style="padding: 2px; text-align: center">General Stats</td>
    </tr>

    <?php
      $role_images[] = "";
        unset($role_images);

        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/{$GLOBALS['cfg']['roleset']}/$player_data_0[team]/$player_data_0[role].webp";
        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/{$GLOBALS['cfg']['roleset']}/$player_data_0[team]/$player_data_0[role].jpg";
        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/{$GLOBALS['cfg']['roleset']}/$player_data_0[team]/$player_data_0[role].png";
      
        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/{$GLOBALS['cfg']['roleset']}/default/default.webp";
        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/{$GLOBALS['cfg']['roleset']}/default/default.jpg";
        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/{$GLOBALS['cfg']['roleset']}/default/default.png";
        $role_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/rolesets/default/default.webp";
        $role_images[] = "../../games/default/rolesets/default/default.webp";

        $no_of_role_images = count($role_images);
        for ($i = 0;$i < $no_of_role_images; $i++) {
            if (is_file($role_images[$i])) {
                $role_image = $role_images[$i];
                break;
            }
        } ?>
    <tr class="cellSubHeading">
      <td colspan="2" style="text-align: center; padding: 0px;">
        <img alt="" name="ROLE" src="<?php print $role_image; ?>"> 
      </td>
    </tr>    

    
    <?php


    $count = 0;
        $categoryi = '';
        foreach ($player_data as $data_var => $data_val) {
            if (preg_match("/(.*)\\|(.*)/", $data_var, $ma)) {
                $categoryi_new = $ma[1];
                $data_var = $ma[2];
            } else {
                $categoryi_new = '';
            }

            if (strcmp($categoryi_new, $categoryi)) {
                ?>
        <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >
          <td colspan="2" class="cellSubheading" style="text-align: left;"><?php print fstr($categoryi_new); ?></td>
        </tr>
        <?php
        $categoryi = $categoryi_new;
            }
      
            $count++;
            if ($count % 2 == 1) {
                $cell_class = "cell1";
            } else {
                $cell_class = "cell2";
            } ?>
      <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >
        <td style="text-align: left;"><?php print fstr($data_var); ?></td>
        <td><?php print $data_val; ?></td>
      </tr>
      <?php
        } ?>

    </table>
    <!-- playerdatatable end ##################################################-->
    <?php
    }
}
//*************************************************************************
function readPlayerData()
{
  global $db,$player_data,$gicon;
  
  $sql = "SELECT dataName,dataValue
    FROM {$GLOBALS['cfg']['db']['table_prefix']}playerdata
    WHERE {$GLOBALS['cfg']['db']['table_prefix']}playerdata.playerID={$GLOBALS['qplayerID']}
    AND gameID=0
    AND dataNo=0
    ORDER BY dataName";

  $rs = $db->Execute($sql);
  
  $player_data = $rs->GetAssoc();


  if (!isset($player_data['quote'])) {
    $player_data['quote'] = "";
  }
  
  $player_data['team'] = "default";
  $player_data['role'] = "default";
  $player_data['icon'] = "default";
  $icon_count_max = 0;

  if (isset($gicon)) {
    foreach ($gicon[$GLOBALS['playerID']] as $teamIDi => $teamIDi_val) {
      foreach ($teamIDi_val as $rolei => $rolei_val) {
        foreach ($rolei_val as $iconi => $iconi_val) {
          if ($iconi_val > $icon_count_max) {
            $icon_count_max = $iconi_val;
            $player_data['icon'] = $iconi;
            $player_data['role'] = $rolei;
            $player_data['team'] = $teamIDi;
          }
        }
      }
    }
  }
  
  if (strlen($player_data['team'])<1) {
    $player_data['team'] = 'default';
  }
  if (strlen($player_data['role'])<1) {
    $player_data['role'] = 'default';
  }
  if (strlen($player_data['icon'])<1) {
    $player_data['icon'] = 'default';
  }

  $sql = "SELECT playerName,skill,kills,deaths,kill_streak,death_streak,games
    FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile
    WHERE {$GLOBALS['cfg']['db']['table_prefix']}playerprofile.playerID={$GLOBALS['qplayerID']}";

  $rs = $db->Execute($sql);

  $player_data['playerName'] = $rs->fields[0];
  $player_data['skill'] = $rs->fields[1];
  $player_data['games'] = $rs->fields[6];
  $player_data['kills'] = $rs->fields[2];
  $player_data['deaths'] = $rs->fields[3];
  $player_data['kill_streak'] = $rs->fields[4];
  $player_data['death_streak'] = $rs->fields[5];

  $player_data['kills:game'] = round($player_data['kills']/$player_data['games'], 2);
  $player_data['kills:death'] = round($player_data['kills']/(1+$player_data['deaths']), 2);
}
//*************************************************************************
function drawProfile()
{
  global $db,$player_data,$player_data_0,$icon_image; ?>
  <!-- profile table start ##################################################-->
  <table class="vsppadding2" style="border-width: 0" width="100%">
    <tr>
      <td colspan="2" class="cellHeading" style="text-align: right;">
        &nbsp;
      </td>
    </tr>
    <tr class="cell1">
      <td width="100%" style="vertical-align: top; text-align: left; font-size: larger;">
      <?php print processColors(htmlspecialchars($player_data_0['playerName']), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length_big']) ?><br><br>
      <?php
      if ($GLOBALS['settings']['display']['quotes']!=0 && strlen($player_data_0['quote']) > 0) {
        print "&nbsp;&nbsp;&nbsp;- \" ".processColors(htmlspecialchars($player_data_0['quote']), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length_big'])." \"";
      } ?>
    </td>

    <?php

    $icon_images[] = "";
    unset($icon_images);
    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/$player_data_0[team]/$player_data_0[role]/".stripIllegalFilenameChars($player_data_0['icon'], "\\/").".webp";
    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/$player_data_0[team]/$player_data_0[role]/".stripIllegalFilenameChars($player_data_0['icon'], "\\/").".jpg";
    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/$player_data_0[team]/$player_data_0[role]/".stripIllegalFilenameChars($player_data_0['icon'], "\\/").".png";

    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/default.webp";
    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/default.jpg";
    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/default.png";
    
    $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/default/default.webp";
    $icon_images[] = "../../games/default/iconsets/default/default.webp";
    
    $no_of_icon_images = count($icon_images);
    for ($i = 0; $i < $no_of_icon_images; $i++) {
      if (is_file($icon_images[$i])) {
        $icon_image = $icon_images[$i];
        break;
      }
    }
    //echo $icon_image; ?>
    <td style="text-align: center; vertical-align: bottom;">
      <img alt="" name="ICON" src="<?php print $icon_image; ?>">
    </td>

    </tr>

  </table>
  <!-- profile table end ##################################################-->
  <?php
}
//*************************************************************************
function drawHitbox()
{
  ksort($GLOBALS['g_hitbox']);
  $hitbox_param = "";
  foreach ($GLOBALS['g_hitbox'] as $loc => $val) {
    $hitbox_param .= "H[$loc]" . "=" . "$val&amp;";
  }
 ?>
    
  <!-- hitbox    table begin ##################################################-->
  <table class="vsppadding2" style="border-width: 0;" width="100%">
    <tr>
      <td colspan="2" class="cellHeading" style="text-align: center;">Hitbox</td>
    </tr>

    <?php
    if (extension_loaded('gd')) {
      ?>
      <tr class="cellSubHeading">
        <td style="text-align: center; padding: 0px;"><img alt="" name="HITBOX" src="./hitbox.php?<?php echo $hitbox_param; ?>"></td>
      </tr>
      <?php
    } ?>
    </table>
    <table class="sortable,vsppadding2" style="border-width: 0px;" width="100%" id="hitbox">  
    <tr class="cellSubHeading">          
      <td style="text-align: left;">Location</td>
      <td style="text-align: right;" sortdir="down">Hits</td>
      <td style="text-align: right;" sortdir="none">%</td>      
    </tr>

    <?php
    $count = 0; // Initialize the count variable
    foreach ($GLOBALS['g_hitbox'] as $loc => $val) {
      if ($loc == 'ALL') {
        continue;
      }
      $count++;
      if ($count % 2 == 1) {
        $cell_class = "cell1";
      } else {
        $cell_class = "cell2";
      } ?>
      <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >          
        <td style="text-align: left;"><?php echo ucfirst($loc); ?></td>
        <td style="text-align: right;"><?php echo $val; ?></td>
        <td style="text-align: right;"><?php printf("%02d", ($val/$GLOBALS['g_hitbox']['ALL'])*100); ?></td>
      </tr>
      <?php
      } ?>
    </table>
    <!-- hitbox    table end ##################################################-->
    <?php
}
//*************************************************************************
function drawGamesList()
{
  global $db,$ggame,$start_from;
  $start_from = 0;

  if (count($ggame) == 0) {
    return;
  } ?>
  <!-- gamestats table begin ##################################################-->
  <table class="vsppadding2" style="border-width: 0" width="100%">
    <tr>
      <td colspan="2" class="cellHeading" style="text-align: center; padding-left: 20px; padding-right: 20px">Games List (last <?php echo $GLOBALS['cfg']['display']['record_limit']; ?>)</td>
    </tr>

    <tr class="cellSubHeading">
      <td colspan="2" style="text-align: center">Time, Map</td>
    </tr>

  <?php

  krsort($ggame);

  $count = 0;
  foreach ($ggame as $gID  => $val) {
    $sql = "SELECT name,value 
      FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata
      where gameID=$gID
      AND
      (name='_v_time_start' OR name='_v_map')
      ORDER BY name DESC";

    $rs = $db->Execute($sql);

    $time_start = $rs->fields[1];
    $rs->MoveNext();
    $map = $rs->fields[1];
    
    $count++;
    if ($count % 2 == 1) {
      $cell_class = "cell1";
    } else {
      $cell_class = "cell2";
    } ?>
    <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
    <td style="border-right-width: 0px;"><?php print $count; ?></td>
    <td style="text-align: left; border-left-width: 0px;">
      <a class="tooltip" title="<?php print "$time_start, $map"?>" href="gamestat.php?gameID=<?php print $gID."&amp;config=$GLOBALS[config]"; ?>">
        <?php print substr($time_start, 5, 5).", ".processColors(htmlentities($rs -> fields[1]), 0, $GLOBALS['settings']['display']['max_char_length_small']); ?>
      </a>
    </td>
    </tr>
    <?php
    if ($count >= $GLOBALS['cfg']['display']['record_limit']) {
      break;
    }
  } ?>
  </table>
  <!-- gamestats table end ##################################################-->
  <?php
}
//*************************************************************************
function drawWeaponStats()
{
  include "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$GLOBALS['cfg']['weaponset']}-weapons.php";
  global $db,$gmatrix,$gmatrixtotal,$gweapon;
  ?>
  <!-- weaponstats table begin ##################################################-->
  <table class="sortable,vsppadding1" style="border-width: 0" width="100%" id="weaponstats">
    <tr class="cellSubHeading">
    <td style="text-align: left;">Weapon</td>
    <td width="10%" sortdir="down">Kills</td>
    <td width="10%">Deaths</td>
    <td width="10%">Suicides</td>
    <td width="10%">Eff %</td>
    <?php
    if (isset($GLOBALS['g_hitbox'])) {
      ?>
      <td width="10%">Hits</td>
      <td width="10%">Shots</td>
      <td width="10%">Misses</td>
      <td width="10%">Acc %</td>
      <?php
    } ?>
    <td width="1%" style="text-align: center;" sortdir="none">&nbsp;</td>
    </tr>
  <?php
  
  $count = 0;

  foreach ($gweapon as $weapon => $val) {
    $count++;
    if ($count % 2 == 1) {
      $cell_class = "cell1";
    } else {
      $cell_class = "cell2";
    }

    $kills = isset($gmatrixtotal['_v_player'][$weapon]['kills']) ? $gmatrixtotal['_v_player'][$weapon]['kills'] : 0;
    $deaths = isset($gmatrixtotal['_v_player'][$weapon]['deaths']) ? $gmatrixtotal['_v_player'][$weapon]['deaths'] : 0;
    $suicides = isset($gmatrixtotal['_v_player'][$weapon]['suicides']) ? $gmatrixtotal['_v_player'][$weapon]['suicides'] : 0;
    
    $hits = isset($gmatrixtotal['_v_player'][$weapon]['hits']) ? $gmatrixtotal['_v_player'][$weapon]['hits'] : 0;
    $shots = isset($gmatrixtotal['_v_player'][$weapon]['shots']) ? $gmatrixtotal['_v_player'][$weapon]['shots'] : 0;
    
    if (isset($GLOBALS['weaponset'][$weapon]['name'])) {
      $weapon_name = $GLOBALS['weaponset'][$weapon]['name'];
    } else {
      $weapon_name = fstr($weapon);
    } ?>

    <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';" >
    
    <?php
    $weapon_images[] = "";
    unset($weapon_images);
    if (isset($GLOBALS['weaponset'][$weapon]['image'])) {
      $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$GLOBALS['weaponset'][$weapon]['image']}";
    } else {
      //echo $weapon;
      $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$weapon}.webp";
      $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$weapon}.jpg";
      $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$weapon}.png";
    }

    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/default.webp";
    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/default.jpg";
    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/default.png";

    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/default/default.webp";
    $weapon_images[] = "../../games/default/weaponsets/default/default.webp";

    $no_of_weapon_images = count($weapon_images);
    for ($i = 0; $i < $no_of_weapon_images; $i++) {
      if (is_file($weapon_images[$i])) {
        $weapon_image = $weapon_images[$i];
        break;
      }
    }
    ?>

    <td style="text-align: left;"><?php print $weapon_name; ?></td>
    <td><?php print $kills; ?></td>
    <td><?php print $deaths; ?></td>
    <td><?php print $suicides; ?></td>
    <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>
    <?php
    if (isset($GLOBALS['g_hitbox'])) {
        ?>
      <td><?php print $hits; ?></td>
      <td><?php print $shots; ?></td>
      <td><?php print $shots - $hits; ?></td>
      <td><?php printf("%02.2f", 100 * $hits / (0.00001 + $shots)); ?></td>
      <?php
    } ?>
    <td style="text-align: center;"><img style="float: right;" alt="" src="<?php print $weapon_image; ?>"></td>
    </tr>
    <?php
  }

  $kills = isset($gmatrixtotal['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal['_v_player']['_v_weapon']['kills'] : 0;
  $deaths = isset($gmatrixtotal['_v_player']['_v_weapon']['deaths']) ? $gmatrixtotal['_v_player']['_v_weapon']['deaths'] : 0;
  $suicides = isset($gmatrixtotal['_v_player']['_v_weapon']['suicides']) ? $gmatrixtotal['_v_player']['_v_weapon']['suicides'] : 0;

  $hits = isset($gmatrixtotal['_v_player']['_v_weapon']['hits']) ? $gmatrixtotal['_v_player']['_v_weapon']['hits'] : 0;
  $shots = isset($gmatrixtotal['_v_player']['_v_weapon']['shots']) ? $gmatrixtotal['_v_player']['_v_weapon']['shots'] : 0; ?>

  <tr class="cellSubHeading" sortbottom="1">
  <td style="text-align: left;">Total</td>
  <td><?php print $kills; ?></td>
  <td><?php print $deaths; ?></td>
  <td><?php print $suicides; ?></td>
  <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>
  <?php
  if (isset($GLOBALS['g_hitbox'])) {
    ?>
    <td><?php print $hits; ?></td>
    <td><?php print $shots; ?></td>
    <td><?php print $shots - $hits; ?></td>
    <td><?php printf("%02.2f", 100 * $hits / (0.00001 + $shots)); ?></td>
    <?php
  } ?>
  <td style="text-align: center;">&nbsp;</td>
  </tr>
  </table>
  <!-- weaponstats table end ##################################################-->
  <?php
}
//*************************************************************************

?>

<!-- layout table begin ##################################################-->
<table class="vspmain" style="border-width: 2px; border-spacing: 0; padding: 0; margin: 0;" width="100%">

<tr>
  <td style="vertical-align: top; padding: 0px;" colspan="3" class="cellBG">
    <?php drawMainHeading(); ?>
  </td>
</tr>

<tr>
  <td colspan="3" style="border-width: 0px; padding: 0px;">
    <?php drawMenu(); ?>
  </td>
</tr>

<tr>
  <td style="vertical-align: top; padding: 10px 10px 10px 10px; border-width: 0px;" colspan="3" class="cellBG">
    <?php drawHeadBar(); ?>
  </td>
</tr>

<tr>
  <td class="cellBG" style="vertical-align: top; padding: 0px 10px 10px 10px; border-width: 0px;">
    <?php drawPlayerData();?><br>
    <?php //drawPlayerAwardsCompact();?><!--<br>-->
    <?php drawPlayerAliases();?><br>
    <?php drawPlayerGUIDs();?><br>
    <?php drawPlayerIPs();?><br>
  </td>

  <td class="cellBG" style="vertical-align: top; padding: 0px 0px 10px 0px; border-width: 0px;" width="100%" >
    <?php
    //echo $GLOBALS['playerID'];
    drawProfile();?><br>
    <?php
    drawPlayerAwards();
    drawPlayerStats();
    ?>
        
    <!--#######################-->
    <table class="vspmain" style="padding: 0px; border-width: 0px;" width="100%">
    <tr>
      <td width="50%" style="vertical-align: top; border-width: 0px; padding: 0px 5px 0px 0px;">
        <?php
          drawPreyOrEnemyList("prey", 25);
        ?>
      </td>
      <td width="50%" style="vertical-align: top; border-width: 0px; padding: 0px 0px 0px 5px;">
        <?php
          drawPreyOrEnemyList("enemy", 25);
        ?>
      </td>
      </tr>
    </table>
    <!--#######################-->
    </td>


    <td class="cellBG" style="vertical-align: top; padding: 0px 10px 10px 10px; border-width: 0px;">

    <?php
    if (isset($GLOBALS['g_hitbox']) && count($GLOBALS['g_hitbox'])>1) {
      drawHitbox(); ?><br><?php
    }
    ?>
    
    <?php
      if ($GLOBALS['settings']['display']['gamestats']) {
        drawGamesList();
      }
    ?>
      
    </td>
    </tr>

    <tr>
      <td colspan="3" style="vertical-align: top; padding: 0px; border-width: 0px;" class="cellBG">
      <?php
       drawCredits();
      ?>
      </td>
    </tr>
  </table>
<!-- layout table end ##################################################-->
<?php

if ($settings['display']['javascript_tooltips']) {
  ?>
<script type="text/javascript">domTT_replaceTitles();</script>
<?php
}
?>
</body>
</html>