<?php
if (!defined('IN_VSP')) {
  header( 'HTTP/1.0 403 Forbidden', TRUE, 403 );
  include '../error403.html';
  exit;
}
//==============================================================================================================================
// Anything following double slashes // are comments.
// You can use // to disable certain settings. 
// Remove the // infront of a variable if you want to enable it.
//==============================================================================================================================
global $cfg;
$cfg['display'] = [];
//==============================================================================================================================
// Error Reporting
    
  // For Debugging. Recommended when you set up vsp for the first time.
  error_reporting(E_ALL ^ E_NOTICE);
  
  // Recommended for regular use after ensuring proper run of vsp.
  //error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
  
  // For Debugging. Enable this if you are having a hard time getting vsp running.
  //error_reporting(E_ALL);

//==============================================================================================================================
// Database settings \\
//    
  // Uncomment/Enable this only if you have and want to use your own adodb libraries.
  // Must specify it as an absolute path! ie:- "../../adodb" etc. are *NOT ALLOWED*
  //$cfg['db']['adodb_path']= "";
                                                   
  // MySQLi required since PHP 5.5.x
  $cfg['db']['adodb_driver']= 'mysqli';
  // use only lower case to minimize windows/linux portability problems
  $cfg['db']['table_prefix'] = "vsp_";
  // the hostname of the mysql or mariadb host (use IP in linux)
  $cfg['db']['hostname'] = "localhost";
  // use only lower case for dbname to minimize windows/linux portability problems
  $cfg['db']['dbname']   = "myrdd1n";
  // the username for full access of the database
  $cfg['db']['username'] = "myrdd1n";
  // the password used for the database username
  $cfg['db']['password'] = "myrdd1n";

//==============================================================================================================================
// Game settings \\
//
  $cfg['game']['name'] = "default"; /* ►► make sure this is set correctly! Read below! ◄◄ */
                                    /*--------------------------------------------------------------------
                                      In order to find out what values are
                                      acceptable for this variable, look in the
                                      /pub/games/ folder in vsp. Any sub 
                                      directory in this folder is valid.
                                        ex:- 
                                          'cod'     for Call of Duty and all its expansions/mods
                                          'hl'      for Half Life and all its mods
                                          'moh'     for Medal of Honor and all its expansions/mods
                                          'q3a'     for Quake 3 Arena and all its expansions/mods
                                          'rtcw'    for Return to Castle Wolfenstein and all its mods
                                          'sof2'    for Soldier of Fortune 2
                                          'wet'     for Wolfenstein Enemy Territory and all its mods
                                          'default' for games that are not listed in pub/games/
                                    --------------------------------------------------------------------*/

// Themes ■ MAY ■ use the following variables to do special processing for a particular game,mod,type
  $cfg['game']['mod'] = "default";  // not used
  $cfg['game']['type'] = "default"; // not used
// The theme author decides how to use these variables.
// Check the documentation for the theme that you are using

//==============================================================================================================================
// FTP Logs \\
//
  // Files downloaded from ftp server will transfer into this directory.
  $cfg['ftp']['logs_path'] = "./ftplogs/";
  $cfg['ftp']['username'] = "ftp_user";
  $cfg['ftp']['password'] = "ftp_pass";

  // Enable(1)/Disable(0) Passive mode. Some FTP servers may require this to be ON
  $cfg['ftp']['pasv'] = 0;

  // Enable(1)/Disable(0) overwriting of file(s). A value of 0 resumes the log.
  $cfg['ftp']['overwrite'] = 0;

//================================================
// Parser Options \\
//
  // It is consistant to track players with their ID or GUID than name being as players do change names on a whim.
  $cfg['parser']['use_original_playerID'] = 1;
  
  // use the most used playerName (set to 1) OR newest playerName (set to 0) as primary playerName
  $cfg['parser']['use_most_used_playerName'] = 1;                
      
  // You can track players by playername, guid and different ip octects if the game/mod supports it. 
  // Tracking by GUID is always the BEST option if its available. If it does not work track by playername
  
  //----- ►► ONLY UNCOMMENT ONE (1) OF THE OPTIONS BELOW ◄◄ ----- \\
  
  // Default method for tracking, works with all games/mods. If unsure, use this.
  $cfg['parser']['trackID'] = 'playerName';                      
  
  // Track by ip 111.222.333.444 (NOT RECOMMENDED - the full ip of the player will be viewable by anyone)
  //$cfg['parser']['trackID'] = 'ip=/(\d+\\.\d+\\.\d+\\.\d+)/';
  
  // Track by ip 111.222.333.*   (recommended tracking format for ips)
  //$cfg['parser']['trackID'] = 'ip=/(\d+\\.\d+\\.\d+\\.)/U';
  
  // Track by ip 111.222.3*.*
  //$cfg['parser']['trackID'] = 'ip=/(\d+\\.\d+\\.\d)/U';
  
  // Track by ip 111.*.*.*        
  //$cfg['parser']['trackID'] = 'ip=/(\d+\\.)/U';
  
  // Recommended method of tracking, if available for that game/mod
  //$cfg['parser']['trackID'] = 'guid';
  
  //----- ►► ENABLE ONLY ONE (1) OPTION ABOVE ◄◄ ----- \\
//==============================================================================================================================
// Other settings \\
//
  $cfg['awardset'] = "default";
  $cfg['skillset'] = "default";
  $cfg['roleset'] = "default";
  $cfg['iconset'] = "default";
  $cfg['mapset'] = "default";
  $cfg['weaponset'] = "default";

  $cfg['player_ban_list'] = "default";
  $cfg['player_exclude_list'] = "default";

//==============================================================================================================================
// Display settings \\
//
// sets the maximum number of records to display on the main stats page
  $cfg['display']['record_limit'] = 30;
//==============================================================================================================================
//▐█► DO NOT MODIFY THIS BLOCK ◄█▌\\
  $cfg['display']['server_image'] = "../../images/server.png";
  $cfg['display']['v_hcenter_logo'] = "../../images/_vsp_glow_blue.png";
  $cfg['display']['v_hchover_logo'] = "../../images/_vsp_head_center.png";
  $cfg['display']['v_logo'] = "../../images/_vsp_logo.png";
  $cfg['display']['server_title'] = <<<END_OF_SERVER_TITLE
  <a href="https://www.krillinsworld.com/vsp"><img src="{$cfg['display']['v_hcenter_logo']}" onmouseover="this.src='{$cfg['display']['v_hchover_logo']}';" onmouseout="this.src='{$cfg['display']['v_hcenter_logo']}';" /></a>
END_OF_SERVER_TITLE;  
//==============================================================================================================================
// Server info \\
//
// This server info is displayed at the top of the main VSP™ page  
  $cfg['display']['server_info'] = <<<END_OF_SERVER_INFO
  <table style="border-width:0;">
    <tr>
      <td style="border-width:0;padding:3px;text-align:right;color:Lavender">Server IP:</td>
      <td style="border-width:0;padding:3px;text-align:left;color:DarkOrange" >[11.22.33.44]</td>
    </tr>
    <tr>
      <td style="border-width:0;padding:3px;text-align:right;color:Lavender">Game:</td>
      <td style="border-width:0;padding:3px;text-align:left;color:DarkOrange">[Your Server Name]</td>
    </tr>
    <tr>
      <td style="border-width:0;padding:3px;text-align:right;color:Lavender">Owner Contact:</td>
      <td style="border-width:0;padding:3px;text-align:left;color:DarkOrange">YOUR &lt;AT&gt; E-MAIL &lt;DOT&gt; COM</td>
    </tr>
    <tr>
      <td style="border-width:0;padding:3px;text-align:right;color:Lavender">Quote:</td>
      <td style="border-width:0;padding:3px;text-align:left;color:DarkOrange">" Everybody Lies! "</td>
    </tr>
  </table>
END_OF_SERVER_INFO;
//==============================================================================================================================
// Data Filters \\
//
// format :- $cfg['data_filter']['events']['eventCategory'] = REGEXP
// EXAMPLES \\
// $cfg['data_filter']['events']['eventCategory'] = "/^R/";     means exclude the events in the category eventCategory where eventName begins with R
// $cfg['data_filter']['events'][''] = "/.*/";                  means exclude all events in category eventCategory where eventName matches anything

//  $cfg['data_filter']['events']['weapon'] = "/.*/";
//  $cfg['data_filter']['events']['ammo'] = "/.*/";
//  $cfg['data_filter']['events'][''] = "/^(team_CTF_blueflag|team_CTF_redflag)/";
  
//  $cfg['data_filter']['gamedata'][''] = "/^(sv_|g_|p_)/";     means excluse all events in the category gamedata when eventName begin with sv_ g_ p_
//  $cfg['data_filter']['gamedata'][''] = "/.*/";
//==============================================================================================================================
