<?php
$start_time = gettimeofday();

//******************************************************************************
define('IN_VSP', true);
require "./util.php";
require "./all.inc.php";
require getConfig();
require "{$GLOBALS['cfg']['db']['adodb_path']}".'adodb.inc.php';

setSkin();

//htmlprint_r($GLOBALS);
//******************************************************************************
function drawHeadBar()
{
  global $sort,$config; ?>
  <!-- navbar begin          ################################################-->
  <table class="cellHeading vsppadding1" width="100%">
    <tr>
    <td height="25" class="cellHeading" style="border-right-width: 0; text-align: left;padding: 0 0 0 15px">
      <b>Player Stats</b> &nbsp;<?php if (isset($_POST['search_by'])) {
        echo " ( Search results for {$_POST['search_by']} = {$_POST['search_txt']} )";
      } ?>
    </td>
    

    <td class="cellHeading" style="border-left-width: 0; text-align: right;" >
      <!-- search form begin     ################################################-->
      <form style="display:inline" method="post" action="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort"; ?>">

        <select style="text-align: center; border-width: 1px" name="search_by" size="1" class="cellSubHeading">
          <option <?php if (isset($_POST['search_by']) && $_POST['search_by' ] == 'name') {
            echo "selected";
            } ?> style="text-align: left;" class="cellSubHeading" value="name" >Search by Player Name
          </option>
          <option <?php if (isset($_POST['search_by']) && $_POST['search_by'] == 'guid') {
            echo "selected";
            } ?> style="text-align: left;" class="cellSubHeading" value="guid" >Search by Player GUID
          </option>
          <option <?php if (isset($_POST['search_by']) && $_POST['search_by'] == 'ip') {
            echo "selected";
            } ?> style="text-align: left;" class="cellSubHeading" value="ip"   >Search by Player IP
          </option>
          <option <?php if (isset($_POST['search_by']) && $_POST['search_by'] == 'id') {
            echo "selected";
            } ?> style="text-align: left;" class="cellSubHeading" value="id"   >Search by Player ID
          </option>
        </select> 

        <input class="cellSubHeading" style="text-align: center; border-width: 1px" type="text" name="search_txt" size="20">&ensp;
        <button class="cellSubHeading" style="text-align: center; border-width: 1px" type="submit">&thinsp;SEARCH&thinsp;</button>
        <input type="hidden" name="sort_by" value="$sort_by">
      </form>
      <!-- search form end       ################################################-->
    </td>

    </tr>
  </table>
  <!-- navbar end            ################################################-->
  <?php
}
//******************************************************************************
function drawRandomQuotes($in_no)
{
    global $db;
  
    $sql = "SELECT playerName,{$GLOBALS['cfg']['db']['table_prefix']}playerdata.playerID,dataValue
            FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile,{$GLOBALS['cfg']['db']['table_prefix']}playerdata
            WHERE dataName='quote' 
              AND {$GLOBALS['cfg']['db']['table_prefix']}playerdata.playerID={$GLOBALS['cfg']['db']['table_prefix']}playerprofile.playerID
            ORDER BY RAND()
            ";
    $rs = $db->SelectLimit($sql, $in_no, 0);
    if ($rs && !$rs->EOF) {
        ?>
    <!-- quote     table begin ##################################################-->
    <table class="vsppadding2" width="100%">
      <tr>
      <td colspan="2" class="cellHeading" style="text-align: center">Random Player Quotes</td>
      </tr>

      <?php
      $count = 0;
        do {
          $count++;
          if ($count%2 == 1) {
            $cell_class="cell1";
          } else {
            $cell_class="cell2";
          } ?>
        <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
        <td style="text-align: right">
        <a href="playerstat.php?playerID=<?php print rawurlencode($rs->fields[1])."&amp;config=$GLOBALS[config]"; ?>"
        <?php print processColors(htmlentities($rs->fields[0]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length'], 1); ?> </a>
        </td>
        <td width="100%" style="text-align: left">"&nbsp;<?php print processColors(htmlentities($rs->fields[2]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length_big']); ?>&nbsp;"</td>
        </tr>
        <?php
        } while ($rs->MoveNext()); ?>
    </table>
    <!-- quote     table end ##################################################-->
    <br>
    <?php
    }
}
//******************************************************************************
function drawPlayersList()
{
    global $db,$start_from,$config,$sort;

    $sql = "SELECT STD(games) 
            FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile
            ";
    $rs = $db->Execute($sql);
    $avg_games = ($rs && !$rs->EOF) ? $rs->fields[0] : 0;

    if ($GLOBALS['settings']['display']['playerlist_conditions']) {
        $sql = "SELECT playerID,playerName,skill AS skill,kills,deaths,kill_streak,death_streak,games 
                FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile 
                WHERE {$GLOBALS['settings']['display']['playerlist_conditions']}
                ORDER BY {$GLOBALS['sort']} {$GLOBALS['order']}
                ";
    } else {
        $sql = "SELECT playerID,playerName,skill AS skill,kills,deaths,kill_streak,death_streak,games 
                FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile
                ORDER BY {$GLOBALS['sort']} {$GLOBALS['order']}
                ";
    }

    if (isset($_POST['search_txt']) || isset($_POST['search_btn'])) {
      $search_txt = filter_input(INPUT_POST, 'search_txt', FILTER_DEFAULT);
      $search_txt = stripslashes($search_txt);
      $search_txt = trim($search_txt);
      $search_txt = htmlspecialchars($search_txt);
  }
  if (isset($_POST['search_by'])) {
    if ($_POST['search_by'] == 'name') {
      $search_txt = preg_replace_callback("/(.)/", function ($matches) {
        return '(`#[0-9a-fA-F]{6})*'.preg_quote(preg_quote($matches[1],'\''),'\'');
      }, $search_txt);
  
      $sql = "SELECT distinct PP.playerID as playerID,playerName,skill as skill,kills,deaths,kill_streak,death_streak,games 
              FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP,{$GLOBALS['cfg']['db']['table_prefix']}playerdata as PD
              WHERE dataName='alias' 
                AND dataValue REGEXP '$search_txt'
                AND PP.playerID=PD.playerID
              ORDER BY {$GLOBALS['sort']} {$GLOBALS['order']}
              ";
    } elseif ($_POST['search_by'] == 'id') {
        $qsearch_txt=$db->qstr('%'.$search_txt.'%');

        $sql = "SELECT playerID,playerName,skill as skill,kills,deaths,kill_streak,death_streak,games 
                FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile
                WHERE playerID LIKE $qsearch_txt
                ORDER BY {$GLOBALS['sort']} {$GLOBALS['order']}
                ";
    } elseif ($_POST['search_by'] == 'ip') {
        $search_txt_full=$search_txt;

        // only allow searches on first two groups in an ip
        $search_txt='127.';
        if (preg_match("/^(\d{1,3}(\\.\d{1,3})?)/", $search_txt_full, $ma)) {
            $search_txt=$ma[1];
        }

        $sql = "SELECT distinct PP.playerID,playerName,skill as skill,kills,deaths,kill_streak,death_streak,games 
                FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP,{$GLOBALS['cfg']['db']['table_prefix']}playerdata as PD
                WHERE dataName='ip' and dataValue LIKE \"$search_txt%\" and PP.playerID=PD.playerID
                ORDER BY {$GLOBALS['sort']} {$GLOBALS['order']}
                ";
    } elseif ($_POST['search_by'] == 'guid') {
        $search_txt_full=$search_txt;

        $sql = "SELECT distinct PP.playerID,playerName,skill as skill,kills,deaths,kill_streak,death_streak,games 
                FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP,{$GLOBALS['cfg']['db']['table_prefix']}playerdata as PD
                WHERE dataName='guid' and dataValue LIKE \"%$search_txt%\" and PP.playerID=PD.playerID
                ORDER BY {$GLOBALS['sort']} {$GLOBALS['order']}
                ";
    }
  }
    
    $rs = $db->SelectLimit($sql, $GLOBALS['cfg']['display']['record_limit'], $GLOBALS['start_from']);

    if ($rs && !$rs->EOF) {
        ?>
    <!-- mainstats table begin ##################################################-->
    <table class="vsppadding2" width="100%">
      <tr>

        <td class="cellHeading" width="100%" colspan="5" style="text-align: left; border-right: 0">
        Player Listing
        </td>

        <td class="cellHeading" colspan="6" style="text-align: left; border-left: 0">

          <table class="vsppadding2" width="100%">
            <tr>
              <td width="100%" class="cellHeading" style="border-width: 0; text-align: right">
                &nbsp;
              </td>
            </tr>
          </table>
        </td>

      </tr>

      <tr class="cellSubHeading">
      <td width="3%">
        #
      </td>


      <?php
      if (isset($_POST['search_by']) && $_POST['search_by'] == 'id') {
          ?>
        <td width="25%" style="text-align: left">
          <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=playerID&amp;order=ASC"; ?>" class="tooltip" title="Sort by Player ID">ID</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=playerID&amp;order=DESC"; ?>" class="tooltip" title="DESCENDING order">-</a>
        </td>
        <?php
      } else {
          ?>      
        <td width="25%" style="text-align: left">
          <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=playerName&amp;order=ASC"; ?>" class="tooltip" title="Sort by Player Name">Name</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=playerName&amp;order=DESC"; ?>" class="tooltip" title="DESCENDING order">-</a>
        </td>
        <?php
      } ?>
      
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kills&amp;order=DESC"; ?>" class="tooltip" title="Sort by Kills">Kills</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kills&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=deaths&amp;order=DESC"; ?>" class="tooltip" title="Sort by Deaths">Deaths</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=deaths&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=efficiency&amp;order=DESC"; ?>" class="tooltip" title="Sort by Efficiency [(Kills / (1+Kills+Deaths)) x 100]">Eff%</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=efficiency&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kill_streak&amp;order=DESC"; ?>" class="tooltip" title="Sort by Kill Streak">KS</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kill_streak&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=death_streak&amp;order=DESC"; ?>" class="tooltip" title="Sort by Death Streak">DS</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=death_streak&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kd&amp;order=DESC"; ?>" class="tooltip" title="Sort by Kills per Death">K:D</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kd&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+ </a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kg&amp;order=DESC"; ?>" class="tooltip" title="Sort by Kills per Game">K:G</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=kg&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=games&amp;order=DESC"; ?>" class="tooltip" title="Sort by Games Played">Games</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=games&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      <td width="8%">
        <a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=skill&amp;order=DESC"; ?>" class="tooltip" title="Sort by Skill">Skill</a>&nbsp;<a href="<?php print "$_SERVER[PHP_SELF]?config=$GLOBALS[config]&amp;sort=skill&amp;order=ASC"; ?>" class="tooltip" title="ASCENDING order">+</a>
      </td>
      </tr>
    <?php

    $count = 0;
      do {
        $count++;
        if ($count%2 == 1) {
          $cell_class="cell1";
        } else {
          $cell_class="cell2";
        } ?>
      <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
      <td><?php print $GLOBALS['start_from']+$count; ?></td>


      <?php
      if (isset($_POST['search_by']) && $_POST['search_by'] == 'id') {
          ?>
        <td style="text-align: left"><a href="playerstat.php?playerID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>"><?php print(htmlentities($rs->fields[0])); ?></a></td>
        <?php
      } else {
          ?>
        <td style="text-align: left"><a href="playerstat.php?playerID=<?php print rawurlencode($rs->fields[0])."&amp;config=$GLOBALS[config]"; ?>"<?php print processColors(htmlentities($rs->fields[1]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length'], 1); ?> </a> </td>
        <?php
      } ?>



      <td><?php print $rs->fields[3]; ?></td>
      <td><?php print $rs->fields[4]; ?></td>

      <td><?php printf("%0.2f", 100*$rs->fields[3]/(1+$rs->fields[3]+$rs->fields[4])); ?>%</td>

      <td><?php print $rs->fields[5]; ?></td>
      <td><?php print $rs->fields[6]; ?></td>

      <td><?php printf("%0.2f", $rs->fields[3]/(1+$rs->fields[4])); ?></td>
      <td><?php printf("%0.2f", $rs->fields[3]/(1+$rs->fields[7])); ?></td>

      <td><?php print $rs->fields[7]; ?></td>

      <td><?php printf("%d", $rs->fields[2]); ?></td>

      </tr>
      <?php
        } while ($rs->MoveNext()); ?>




  <tr>
    
    <td colspan="11" class="cellHeading" style="border-width: 0; border-left-width: 0; border-right-width: 0; text-align: left" width="100%">

      <table class="vsppadding2" width="100%">
        <tr>
         <td width="100%" style="border-width: 0; text-align: left">
          <!-- goto   form begin     ################################################-->
          <form style="display:inline" method="post" action="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort"; ?>">
          <input class="cellSubHeading" style="text-align: center; border-width: 1px" type="Submit" name="goto_btn" value="&thinsp;goto #&thinsp;">&nbsp;<input class="cellSubHeading" style="text-align: center; border-width: 1;" type="Text" name="goto_txt" size="10">
          <input type="hidden" name="sort_by" value="$sort_by">
          </form>
          <!-- goto   form end       ################################################-->
        </td>

        <td class="cellSubHeading pagination" style="text-align: right">&nbsp;
          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from=0"; ?>" class="pagination-link">First</a>
          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['prev']}"; ?>" class="pagination-link">&laquo; Prev</a>
          <span class="pagination-info">Page<?php echo ceil($GLOBALS['start_from'] / $GLOBALS['cfg']['display']['record_limit']) + 1; ?>
            of <?php echo ceil($GLOBALS['total_records'] / $GLOBALS['cfg']['display']['record_limit']); ?></span>
          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['next']}"; ?>" class="pagination-link">Next &raquo;</a>
          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['total_records']}"; ?>" class="pagination-link">Last</a>
          &nbsp;
        </td>

        </tr>
      </table>


    </td>
  </tr>








    </table>
    <!-- mainstats table end ##################################################-->
    <?php
    }
} 
//******************************************************************************
function drawAwards()
{
    global $db, $award_image;

    $sql = "SELECT name,image,playerName,category,{$GLOBALS['cfg']['db']['table_prefix']}awards.playerID,awardID 
            FROM {$GLOBALS['cfg']['db']['table_prefix']}awards,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile
            WHERE {$GLOBALS['cfg']['db']['table_prefix']}awards.playerID={$GLOBALS['cfg']['db']['table_prefix']}playerprofile.playerID
            ORDER BY category,name
            ";
    $rs = $db->Execute($sql);
  
    if ($rs && !$rs->EOF) {
        ?>
    <!-- awards    table begin ##################################################-->
    <table class="vsppadding2" width="100%">
    <tr>
      <td colspan="2" width="100%"  class="cellHeading" style="text-align: center; padding-left: 50px; padding-right: 50px;">Awards List</td>
    </tr>

    <?php
    do {
        ?>
      <tr>
        <td colspan="2" width="100%"  class="cellSubHeading" style="text-align: center"><?php print $rs->fields[3]; ?></td>
      </tr>    
      <?php

      $count=0;
        do {
          $count++;
          if ($count%2 == 1) {
            $cell_class = "cell1";
          } else {
            $cell_class = "cell2";
          }

          $cat = $rs->fields[3];

          $award_images[] = "";
          unset($award_images);
          $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".webp";
          $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".jpg";
          $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/{$rs->fields[1]}".".png";
          $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/{$GLOBALS['cfg']['awardset']}/default.webp";
          $award_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/awardsets/default/default.webp";
          $award_images[] = "../../games/default/awardsets/default/default.gif";

          $no_of_award_images = count($award_images);
          for ($i = 0; $i < $no_of_award_images; $i++) {
            if (is_file($award_images[$i])) {
              $award_image = $award_images[$i];
              break;
            }
          } ?>
        <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
          <td style="text-align: center "><a href="awardstat.php?awardID=<?php print rawurlencode($rs->fields[5])."&amp;config=$GLOBALS[config]"; ?>"><img alt="" name="<?php print "AWARD_".$rs->fields[5]; ?>" class="tooltip" title="<?php print $rs->fields[0]; ?>" src="<?php print $award_image; ?>"> </a> </td>
          <td width="100%" style="text-align: left "><a href="playerstat.php?playerID=<?php print rawurlencode($rs->fields[4])."&amp;config=$GLOBALS[config]"; ?>"<?php print processColors(htmlspecialchars($rs->fields[2]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length'], 1); ?> </a> </td>
        </tr>
        <?php
        } while ($rs->MoveNext() && strcmp($cat, $rs->fields[3])==0);
    } while (!$rs->EOF); ?>
    </table>
    <!-- awards    table end ##################################################-->
    <?php
    }
}
//******************************************************************************
function drawGamesList()
{
    global $db;


    $sql = "SELECT distinct gameID
            FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata 
            ORDER BY gameID DESC
            ";
    $rs = $db->SelectLimit($sql, $GLOBALS['cfg']['display']['record_limit']);

    if ($rs && !$rs->EOF) {
        $gameID_max = $rs->fields[0];
        $rs->MoveLast();
        $gameID_min = $rs->fields[0];
    } else {
    $gameID_min = 0;
    $gameID_max = 0;
    }

    $sql = "SELECT gameID,value 
            FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata 
            WHERE gameID >= $gameID_min
              AND gameID <= $gameID_max
              AND (name='_v_map' OR name='_v_time_start')
            ORDER BY gameID DESC,name ASC
            ";

    $rs = $db->Execute($sql);
  
    if ($rs && !$rs->EOF) {
        ?>
    <!-- gamestats table begin ##################################################-->
    <table class="vsppadding2" width="100%">
      <tr>
      <td colspan="2" class="cellHeading" style="text-align: center; padding-left: 50px; padding-right: 50px;">Recent Games</td>
      </tr>

      <tr>
      <td colspan="2" class="cellSubHeading" style="text-align: center">Time, Map</td>
      </tr>

    <?php

    $count = 0;
      do {
        $count++;
          if ($count%2 == 1) {
            $cell_class = "cell1";
          } else {
            $cell_class = "cell2";
          }

          $map = $rs->fields[1];
          $rs->MoveNext();
          $time_start = $rs->fields[1]; ?>
      <tr class="<?php print "$cell_class"?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print "$cell_class"?>';" >
      <td style="border-right-width: 0;"><?php print $count; ?></td>
      <td style="text-align: left; border-left-width: 0;">
      <a class="tooltip" title="<?php print "$time_start, $map"?>" href="gamestat.php?gameID=<?php print $rs->fields[0]."&amp;config=$GLOBALS[config]"; ?>">
      <?php
        print substr($time_start, 5, 11).", ".processColors(htmlentities($map), 0, $GLOBALS['settings']['display']['max_char_length_small']); ?>
      </a>
      </td>
      </tr>
      <?php
        } while ($rs->MoveNext()); ?>
    </table>
    <!-- gamestats table end ##################################################-->
    <?php
    }
}
//******************************************************************************
function displayStats()
{
    ?>
  <!-- layout table begin ##################################################-->
  <table class="vspborderwidth2" width="100%">
  <tr>
    <td style="vertical-align: top; border-width: 0; padding: 0;" colspan="3" class="cellBG">
      <?php drawMainHeading(); ?>
    </td>
  </tr>

  <tr>
    <td colspan="3" style="border-width: 0; padding: 0;">
      <?php drawMenu(); ?>
    </td>
  </tr>



  <tr>
    <td style="vertical-align: top; padding: 10px 5px 10px 5px; border-width: 0;" colspan="3" class="cellBG">
      <?php drawHeadBar(); ?>
    </td>
  </tr>


  <tr>
    <?php
    if ($GLOBALS['settings']['display']['mini_awardstats_list']) {
        ?>
      <td style="vertical-align: top; padding: 0 0 10px 10px; border-width: 0;" class="cellBG">
        <?php drawAwards(); ?>
      </td>
      <?php
    } ?>

    <td style="vertical-align: top; padding: 0 10px 10px 10px; border-width: 0;" class="cellBG" width="80%">  
      <?php
        if ($GLOBALS['settings']['display']['quotes'] > 0) {
            drawRandomQuotes($GLOBALS['settings']['display']['quotes']);
        }
    drawPlayersList(); ?>
    </td>

    <?php
    if ($GLOBALS['settings']['display']['gamestats'] && $GLOBALS['settings']['display']['mini_gamestats_list']) {
        ?>
      <td style="vertical-align: top; padding: 0 10px 10px 0; border-width: 0;" class="cellBG">
        <?php drawGamesList(); ?>
      </td>
      <?php
    } ?>




  </tr>

  <tr>
    <td colspan="3" style="vertical-align: top; padding: 0; border-width: 0;" class="cellBG">
      <?php
      drawCredits(); ?>
    </td>
  </tr>
  </table>
  <!-- layout table end   ##################################################-->
  <?php
}
//******************************************************************************
function setupVars()
{
    global $db,$start_from,$sort,$order,$prev,$next,$total_records;

    $sql = "SELECT count(*) 
            FROM {$GLOBALS['cfg']['db']['table_prefix']}playerprofile
            ";
    $rs = $db->Execute($sql);
    $total_records = ($rs && !$rs->EOF) ? $rs->fields[0] : 0;

  

    //******************
    if (isset($_POST['goto_btn']) || isset($_POST['goto_txt'])) {
      $start_from = intval($_POST['goto_txt']) - 1;
    } elseif (isset($_GET['start_from'])) {
      $start_from = $_GET['start_from'];
    }
  
    //********
    // limit checks
    if ($start_from >= $total_records) {
      $start_from = $total_records-$GLOBALS['cfg']['display']['record_limit'];
    }
    if (!isset($start_from) || $start_from < 0) {
      $start_from = 0;
    }
    //********
    //******************
  
  
    //******************
    $next = $start_from+$GLOBALS['cfg']['display']['record_limit'];
    $prev = $start_from-$GLOBALS['cfg']['display']['record_limit'];

    //********
    // limit checks
    if ($prev < 0) {
      $prev = 0;
    }

    if ($next>$total_records) {
      $next = $total_records;
    }
    //********
    //******************
  
    if (isset($_GET['order'])) {
      $order = $_GET['order'];
    }
  
    if (!isset($order) || ($order != 'ASC' && $order != 'DESC')) {
      $order = 'DESC';
    }

    if ($order == 'DESC') {
      $new_order = 'ASC';
    } elseif ($order == 'ASC') {
      $new_order = 'DESC';
    }

    if (isset($_GET['sort'])) {
      $sort = $_GET['sort'];
    }
  
    if (!isset($sort) || strstr($sort, ";")) {
      $sort = $GLOBALS['settings']['display']['default_sort'];
    }
  
    if ($sort == "efficiency") {
      $sort = "((kills*100)/(1+kills+deaths))";
    }

    if ($sort == "kd") {
      $sort = "(kills/(1+deaths))";
    }

    if ($sort == "kg") {
      $sort = "(kills/(1+games))";
    }


    //******************


    if (!is_dir("../../games/{$GLOBALS['cfg']['game']['name']}")) {
      $GLOBALS['cfg']['game']['name'] = 'default';
    }
}


//******************************************************************************
?>

<!DOCTYPE html>
<html lang="en-US" dir="ltr">
<head>
<meta charset="utf-8">
<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
<link rel="manifest" href="favicon/site.webmanifest">
<link rel="stylesheet" href="css/style.css" type="text/css">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<title>VSP™ stats</title>
<link rel=stylesheet href="<?php print $GLOBALS['stylesheet']; ?>" type="text/css">
<?php if ($settings['display']['javascript_tooltips']) {
    includeDOMTT();
}?>
</head>
<?php ob_start("compactHTML");?>
<body>
<?php
  $db = ADONewConnection($GLOBALS['cfg']['db']['adodb_driver']);
  if (!$db->Connect($GLOBALS['cfg']['db']['hostname'], $GLOBALS['cfg']['db']['username'], $GLOBALS['cfg']['db']['password'], $GLOBALS['cfg']['db']['dbname'])) {
    print "Error: can not establish database connection or the database {$GLOBALS['cfg']['db']['dbname']} does not exist.\n";
    exit();
  }

  //$db->SetFetchMode(ADODB_FETCH_ASSOC);
  $db->SetFetchMode(ADODB_FETCH_NUM);
  setupVars();
  
  displayStats();

  if ($settings['display']['javascript_tooltips']) {
      ?>
    <script type="text/javascript">domTT_replaceTitles();</script>
    <?php
  }
?>
</body>
</html>
