<?php
$start_time = gettimeofday();

define('IN_VSP', true);
require "./util.php";
require "./all.inc.php";
require getConfig();

require "{$GLOBALS['cfg']['db']['adodb_path']}" . 'adodb.inc.php';




$db = ADONewConnection("{$GLOBALS['cfg']['db']['adodb_driver']}");
if (!$db->Connect($GLOBALS['cfg']['db']['hostname'], $GLOBALS['cfg']['db']['username'], $GLOBALS['cfg']['db']['password'], $GLOBALS['cfg']['db']['dbname'])) {
  print "ERROR: Can not establish database connection.\n";
  exit();
}

$db->SetFetchMode(ADODB_FETCH_NUM);



$categories_per_row = 3;


setSkin();


setupVars();

// if gameID is set but not a number, then get rid of it
if (isset($_GET['gameID']) && !ctype_digit($_GET['gameID'])) {
  unset($_GET['gameID']);
}

$gameID = isset($_GET['gameID']) ? $_GET['gameID'] : null;

if ($gameID) {
  getStats();
  getStats1D();
  getStatsGame();


  global $gteam;
  if (!is_array($gteam)) {
    $gteam = [];
  }
  // To make it easy for making team classes for style sheets, assign a counter type index to each unique team and use that for naming the classes
  // I.E. instead of having teamRED teamBLUE classes in css. Designing a css for that would require knowledge of the name of the team
  // Instead use Team1 , Team2, Team3 etc
  $i = 0;
  ksort($gteam);
  foreach ($gteam as $teamID_key => $val) {
    $i++;
    $gteam_index[$teamID_key] = $i;
  }
  getPlayerNames();
}

include_once "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$GLOBALS['cfg']['weaponset']}-weapons.php";


?>

<!DOCTYPE html>
<html lang="en-US" dir="ltr">

<head>
  <meta charset="utf-8">
  <link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
  <link rel="manifest" href="favicon/site.webmanifest">
  <link rel="stylesheet" href="css/style.css" type="text/css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

  <title>VSP™ (game stats)</title>
  <link rel=stylesheet href="<?php print $GLOBALS['stylesheet']; ?>" type="text/css">
  <script language="javascript" type="text/javascript" src="../../lib/sorttable/sorttable.js"></script>
  <script language="JavaScript" type="text/javascript">
    var oldKillChartTable = "KillChartTable_v_weapon";

    function displayKillChart(chart) {
      // This feature doesn't seem to work in IE and i don't want to write a work around for a non-standard browser like IE. 
      // Use Firefox or Chrome :)
      var newKCT;
      var oldKCT;
      newKCT = document.getElementById(chart);
      oldKCT = document.getElementById(oldKillChartTable);
      oldKCT.setAttribute("style", "display:none;");
      newKCT.setAttribute("style", "display:table; border-width: 0");
      oldKillChartTable = chart;
      return;
    }
  </script>
</head>

<?php
$pre_time = timeElapsed($start_time);
ob_start("compactHTML");
?>

<body>




  <?php
  //*************************************************************************
  function drawHeadBar()
  {
    global $sort, $config; ?>
    <!-- navbar begin          ################################################-->
    <table class="cellHeading,vappadding1" width="100%">
      <tr>
        <td height="25" class="cellHeading" style="border-right-width: 0; text-align: center;">
          <b>Game Stats</b>
        </td>
      </tr>
    </table>
    <!-- navbar end            ################################################-->
    <?php
  }
  //*************************************************************************
  function drawKillChart()
  {
    global $gmatrix, $gmatrixtotal, $gteam, $gweapon, $gplayerName, $gteam_index;



    if (count($GLOBALS['gplayerName']) > 10) {
      $max_char_length = $GLOBALS['settings']['display']['max_char_length_small'];
    } else {
      $max_char_length = $GLOBALS['settings']['display']['max_char_length'];
    }

    $gteam1 = $gteam;
    $gteam2 = array_reverse($gteam, true);
    $no_of_teams = count($gteam);

    foreach ($gteam1 as $team1 => $team1_val) {
      foreach ($gteam2 as $team2 => $team2_val) {
        if ($no_of_teams > 1 && $team1 == $team2) {
          break;
        } ?>
        <table class="vsppadding2" width="100%">

          <tr>
            <td class="cellHeading" style="text-align: left; border-right: 0;">
              Kill Chart
            </td>

            <td class="cellHeading" style="border-left: 0;">
              <form style="margin: 0" action="">
                <select class="cellSubHeading" style="text-align: left; width: 200px" name="KillChartSelect" OnChange="displayKillChart(form.KillChartSelect.options[form.KillChartSelect.selectedIndex].value);">
                  <option value="KillChartTable_v_weapon" selected="selected">
                    All weapons
                  </option>

                  <?php
                  //------------------------------------------------------
                  if ($GLOBALS['settings']['display']['gamestats_killchart_per_weapon']) {
                    foreach ($gweapon as $weapon => $val) {
                      print "<option value=\"KillChartTable$weapon\">";
                      print fstr($weapon);
                      print "</option>";
                    }
                  }
                  //------------------------------------------------------
                  ?>

                </select>
              </form>
            </td>

          </tr>
        </table>
        <?php




        $no_of_players_team2 = (isset($gmatrix[$team2]) && is_array($gmatrix[$team2])) ? count($gmatrix[$team2]) : 0;
        $cell_width = round(100 / (2 + $no_of_players_team2), 2);

        //------------------------------------------------------
        if ($GLOBALS['settings']['display']['gamestats_killchart_per_weapon']) {
          foreach ($gweapon as $weapon => $val) {
        ?>
            <table class="vsppadding2" ID="<?php echo "KillChartTable" . $weapon; ?>" width="100%">

              <tr class="cellSubHeading">
                <td class="cellSubHeading" style="text-align: right" width="<?php print $cell_width; ?>%">
                  Players
                </td>
                <?php

                foreach ($gmatrix[$team2] as $team2player => $team2player_val) {
                  echo "<td colspan=\"2\" class=\"Team" . $gteam_index[$team2] . "\" style=\"text-align: center \" width=\"" . $cell_width . "%\">" . processColors(htmlspecialchars($gplayerName[$team2player]), $GLOBALS['settings']['display']['color_names'], $max_char_length) . "</td>";
                }
                echo "<td colspan=\"2\" class=\"Team" . $gteam_index[$team2] . "\" style=\"text-align: center \" width=\"" . $cell_width . "%\">Total</td>";
                echo "</tr>\n";

                $count = 0;
                foreach ($gmatrix[$team1] as $team1player => $team1player_val) {
                  if ($count % 2 == 0) {
                    $cell_class = "cell1";
                  } else {
                    $cell_class = "cell2";
                  }
                  $count++; ?>
              <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">
              <?php
                  echo "<td class=\"Team" . $gteam_index[$team1] . "\"style=\"text-align: right \" >" . processColors(htmlspecialchars($gplayerName[$team1player]), $GLOBALS['settings']['display']['color_names'], $max_char_length) . "</td>";
                  foreach ($gmatrix[$team2] as $team2player => $team2player_val) {
                    $kills_team1 = isset($gmatrix[$team1][$team1player][$team2player][$weapon]['kills']) ? $gmatrix[$team1][$team1player][$team2player][$weapon]['kills'] : 0;
                    $kills_team2 = isset($gmatrix[$team2][$team2player][$team1player][$weapon]['kills']) ? $gmatrix[$team2][$team2player][$team1player][$weapon]['kills'] : 0;

                    echo "<td style=\"text-align: right \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team1 . "</td>";
                    echo "<td style=\"text-align: left \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team2 . "</td>";
                  }

                  $kills_team1_total = isset($gmatrixtotal[$team1][$team1player]['_v_player'][$weapon]['kills']) ? $gmatrixtotal[$team1][$team1player]['_v_player'][$weapon]['kills'] : 0;
                  $kills_team2_total = isset($gmatrixtotal[$team2]['_v_player'][$team1player][$weapon]['kills']) ? $gmatrixtotal[$team2]['_v_player'][$team1player][$weapon]['kills'] : 0;

                  echo "<td style=\"text-align: right \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team1_total . "</td>";
                  echo "<td style=\"text-align: left \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team2_total . "</td>";
                  echo "</tr>\n";
                }



                //*********Total Last Row Begin
                $count++;
                if ($count % 2 == 0) {
                  $cell_class = "cell2";
                } else {
                  $cell_class = "cell1";
                } ?>
              <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">
            <?php
            echo "<td class=\"Team" . $gteam_index[$team1] . "\"style=\"text-align: right \" >Total</td>";
            foreach ($gmatrix[$team2] as $team2player => $team2player_val) {
              $kills_team1_total = isset($gmatrixtotal[$team1]['_v_player'][$team2player][$weapon]['kills']) ? $gmatrixtotal[$team1]['_v_player'][$team2player][$weapon]['kills'] : 0;
              $kills_team2_total = isset($gmatrixtotal[$team2][$team2player]['_v_player'][$weapon]['kills']) ? $gmatrixtotal[$team2][$team2player]['_v_player'][$weapon]['kills'] : 0;

              echo "<td style=\"text-align: right \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team1_total . "</td>";
              echo "<td style=\"text-align: left \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team2_total . "</td>";
            }

            $kills_team1_total_all = isset($gmatrixtotal[$team1]['_v_player']['_v_player'][$weapon]['kills']) ? $gmatrixtotal[$team1]['_v_player']['_v_player'][$weapon]['kills'] : 0;
            $kills_team2_total_all = isset($gmatrixtotal[$team2]['_v_player']['_v_player'][$weapon]['kills']) ? $gmatrixtotal[$team2]['_v_player']['_v_player'][$weapon]['kills'] : 0;

            echo "<td style=\"text-align: right \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team1_total_all . "</td>";
            echo "<td style=\"text-align: left \" width=\"" . round($cell_width / 2, 2) . "%\">" . $kills_team2_total_all . "</td>";
            echo "</tr>\n";
            //*********Total Last Row End

            echo "</table>\n";
          }
        }
        //------------------------------------------------------
            ?>
            <table class="vsppadding2" ID="KillChartTable_v_weapon" width="100%">

              <tr class="cellSubHeading">
                <td width="<?php print $cell_width; ?>%">
                  Players
                </td>
                <?php
                if (isset($gmatrix[$team2]) && is_array($gmatrix[$team2])) {
                  foreach ($gmatrix[$team2] as $team2player => $team2player_val) {
                    echo "<td colspan=\"2\" class=\"Team" . $gteam_index[$team2] . "\" style=\"text-align: center \" width=\"" . $cell_width . "%\">" . "<a href=\"##\"" . processColors(htmlspecialchars($gplayerName[$team2player]), $GLOBALS['settings']['display']['color_names'], $max_char_length, 1) . "</a></td>";
                  }
                  echo "<td colspan=\"2\" class=\"Team" . $gteam_index[$team2] . "\" style=\"text-align: center \" width=\"" . $cell_width . "%\">Total</td>";
                  echo "</tr>\n";

                  $count = 0;
                  foreach ($gmatrix[$team1] as $team1player => $team1player_val) {
                    if ($count % 2 == 0) {
                      $cell_class = "cell1";
                    } else {
                      $cell_class = "cell2";
                    }
                    $count++; ?>
                    <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">
                    <?php
                    echo "<td class=\"Team" . $gteam_index[$team1] . "\">" . "<a href=\"##\"" . processColors(htmlspecialchars($gplayerName[$team1player]), $GLOBALS['settings']['display']['color_names'], $max_char_length, 1) . "</a></td>";
                    foreach ($gmatrix[$team2] as $team2player => $team2player_val) {
                    $kills_team1 = isset($gmatrixtotal[$team1][$team1player][$team2player]['_v_weapon']['kills']) ? $gmatrixtotal[$team1][$team1player][$team2player]['_v_weapon']['kills'] : 0;
                    $kills_team2 = isset($gmatrixtotal[$team2][$team2player][$team1player]['_v_weapon']['kills']) ? $gmatrixtotal[$team2][$team2player][$team1player]['_v_weapon']['kills'] : 0;

                    echo "<td width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team1 . "</td>";
                    echo "<td style=\"text-align:  left \" width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team2 . "</td>";
                  }

                  $kills_team1_total = isset($gmatrixtotal[$team1][$team1player]['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$team1][$team1player]['_v_player']['_v_weapon']['kills'] : 0;
                  $kills_team2_total = isset($gmatrixtotal[$team2]['_v_player'][$team1player]['_v_weapon']['kills']) ? $gmatrixtotal[$team2]['_v_player'][$team1player]['_v_weapon']['kills'] : 0;

                  echo "<td width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team1_total . "</td>";
                  echo "<td style=\"text-align:  left \" width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team2_total . "</td>";
                  echo "</tr>\n";
                }



                //*********Total Last Row Begin
                $count++;
                if ($count % 2 == 0) {
                  $cell_class = "cell2";
                } else {
                  $cell_class = "cell1";
                } ?>
              <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">
            <?php
            echo "<td class=\"Team" . $gteam_index[$team1] . "\">Total</td>";
            foreach ($gmatrix[$team2] as $team2player => $team2player_val) {
              $kills_team1_total = isset($gmatrixtotal[$team1]['_v_player'][$team2player]['_v_weapon']['kills']) ? $gmatrixtotal[$team1]['_v_player'][$team2player]['_v_weapon']['kills'] : 0;
              $kills_team2_total = isset($gmatrixtotal[$team2][$team2player]['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$team2][$team2player]['_v_player']['_v_weapon']['kills'] : 0;

              echo "<td width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team1_total . "</td>";
              echo "<td style=\"text-align: left \" width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team2_total . "</td>";
            }

            $kills_team1_total_all = isset($gmatrixtotal[$team1]['_v_player']['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$team1]['_v_player']['_v_player']['_v_weapon']['kills'] : 0;
            $kills_team2_total_all = isset($gmatrixtotal[$team2]['_v_player']['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$team2]['_v_player']['_v_player']['_v_weapon']['kills'] : 0;

            echo "<td width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team1_total_all . "</td>";
            echo "<td style=\"text-align: left \" width=\"" . round($cell_width / 2, 2) . "%\" >" . $kills_team2_total_all . "</td>";
            echo "</tr>\n";
            //*********Total Last Row End

            echo "</table>\n";
          }
        }
      }
    }

      //*************************************************************************
      function getPlayerNames()
      {
        global $db;
        global $gplayerName;
        foreach ($gplayerName as $playerIDi => $playerNamei) {
          if (!$gplayerName[$playerIDi]) {
            $qplayerIDi = $db->qstr($playerIDi);
            $sql = "select playerName
                      from {$GLOBALS['cfg']['db']['table_prefix']}playerprofile
                      where playerID=$qplayerIDi
                   ";

            $rs = $db->Execute($sql);
            $gplayerName[$playerIDi] = $rs->fields[0];
          }
        }
      }
      //*************************************************************************
      function drawPlayerStats()
      {
        global $db, $gicon, $categories_per_row, $gmatrix1D, $gevent1D, $gmatrix, $gmatrixtotal, $gteam, $gweapon, $gplayerName, $gteam_index, $icon_image;

        $no_of_teams = count($gteam); ?>

            <table class="vspmain" width="100%">
              <tr>
                <?php

                foreach ($gteam as $teamID => $teamID_val) {
                ?>
                  <td width="<?php print round(100 / $no_of_teams, 2); ?>%" style="vertical-align: top; padding: 5px 5px 5px 5px; border-width: 0; " class="cellBG">
                    <?php


                    drawTeamOverall($teamID); ?><br><br><?php

                                        foreach ($teamID_val as $playerID => $val) {



                                          //------------------------------------------------
                                          $player_data['role'] = "default";
                                          $player_data['icon'] = "default";
                                          $icon_count_max = 0;

                                          if (isset($gicon[$teamID][$playerID])) {
                                            foreach ($gicon[$teamID][$playerID] as $rolei => $rolei_val) {
                                              foreach ($rolei_val as $iconi => $iconi_val) {
                                                if ($iconi_val > $icon_count_max) {
                                                  $icon_count_max = $iconi_val;
                                                  $player_data['icon'] = $iconi;
                                                  $player_data['role'] = $rolei;
                                                }
                                              }
                                            }
                                          }

                                          if (strlen($player_data['role']) < 1) {
                                            $player_data['role'] = 'default';
                                          }
                                          if (strlen($player_data['icon']) < 1) {
                                            $player_data['icon'] = 'default';
                                          }
                                          //------------------------------------------------

                                          $icon_images[] = "";
                                          unset($icon_images);
                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/$teamID/{$player_data['role']}/" . stripIllegalFilenameChars($player_data['icon'], "\\/") . ".gif";
                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/$teamID/{$player_data['role']}/" . stripIllegalFilenameChars($player_data['icon'], "\\/") . ".jpg";
                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/$teamID/{$player_data['role']}/" . stripIllegalFilenameChars($player_data['icon'], "\\/") . ".png";

                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/default/default.gif";
                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/default/default.jpg";
                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/{$GLOBALS['cfg']['iconset']}/default/default.png";

                                          $icon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/iconsets/default/default.gif";
                                          $icon_images[] = "../../games/default/iconsets/default/default.gif";

                                          $no_of_icon_images = count($icon_images);
                                          for ($i = 0; $i < $no_of_icon_images; $i++) {
                                            if (is_file($icon_images[$i])) {
                                              $icon_image = $icon_images[$i];
                                              break;
                                            }
                                          }
                                        ?>
                      <table class="vspmain" width="100%">
                        <tr>
                          <td colspan="<?php print $categories_per_row; ?>" width="100%" class="<?php print "team{$gteam_index[$teamID]}"; ?>" style="font-size: 180%; text-align: left">
                            <img alt="" style="float:right" height="25" name="ICON-<?php print fstr($teamID . $playerID); ?>" src="<?php print $icon_image; ?>">
                            <a name="stat-<?php print fstr($teamID . '-' . $playerID); ?>" href="playerstat.php?playerID=<? print rawurlencode($playerID) . "&amp;config=$GLOBALS[config]"; ?>">
                              <?php print processColors(htmlspecialchars($gplayerName[$playerID]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length']); ?>
                            </a>
                          </td>

                        </tr>



                        <?php
                                          $count_cat = 0;

                                          if (isset($gevent1D)) {
                                            foreach ($gevent1D as $eventCategory => $val) {
                                              if ($count_cat % $categories_per_row == 0) {
                                                echo "\n<tr>";
                                              }

                                              $count_cat++; ?>
                            <td width="<?php print round(100 / ($categories_per_row), 2) ?>%" class="cellBG" style="vertical-align: top; text-align: left ;border-width: 0; padding: 0">
                              <?php drawStats1D($playerID, $teamID, $eventCategory); ?>
                            </td>
                          <?php

                                              if ($count_cat % $categories_per_row == 0) {
                                                echo "</tr>\n";
                                              }
                                            }
                                          }

                                          while ($count_cat % $categories_per_row != 0) {
                                            if ($count_cat % $categories_per_row == 0) {
                                              echo "\n<tr>";
                                            }

                                            $count_cat++; ?>
                          <td width="<?php print 100 / $categories_per_row ?>%" class="cellSubHeading" style="vertical-align: top; text-align: left ;border-width: 0; padding: 0">
                            <?php drawStats1D("", "", ""); ?>
                          </td>
                        <?php

                                            if ($count_cat % $categories_per_row == 0) {
                                              echo "</tr>\n";
                                            }
                                          } ?>
                        <tr>
                          <td colspan="<?php print $categories_per_row; ?>" width="100%" class="cellSubHeading" style="vertical-align: top; text-align: left; padding: 0; ">
                            <?php drawWeaponStats($playerID, $teamID); ?>
                          </td>
                        </tr>

                      </table>
                      <br>
                    <?php
                                        } ?>
                  </td>
                <?php
                } ?>
              </tr>
            </table>
          <?php
        }

        //*************************************************************************
        function getStatsGame()
        {
          global $db;
          global $ggame;
          $sql = "SELECT name, value  
            FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata
            WHERE gameID = $GLOBALS[gameID]
         ";

          $rs = $db->Execute($sql);



          if (!$rs || $rs->EOF) {
            return;
          }

          $ggame = $rs->GetAssoc();
        }
        //*************************************************************************
        function drawStatsGame()
        {
          global $ggame, $map_image; ?>
            <!-- game settings begin ##################################################-->
            <table class="vspmain" width="100%">
              <tr>
                <td colspan="3" width="100%" class="cellHeading" style="text-align: left">Map Informataion</td>
              </tr>

              <tr>
                <td class="cellSubHeading" style="padding: 1px 5px 1px 5px; text-align: right">Game Start Time</td>
                <td width="100%" class="cell1" style="padding: 0 5px 0 5px; text-align: left"><?php if (isset($ggame['_v_time_start']) && !is_array($ggame['_v_time_start'])) {
                  echo date('l, F j, Y g:i A', strtotime($ggame['_v_time_start'])); } ?></td>

                <?php
                $map_images = [];
                $map_image = "";
                unset($map_images);
                if (isset($ggame['_v_map'])) {
                  $map = is_array($ggame['_v_map']) ? reset($ggame['_v_map']) : $ggame['_v_map'];
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/{$GLOBALS['cfg']['mapset']}/{$map}.webp";
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/{$GLOBALS['cfg']['mapset']}/{$map}.jpg";
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/{$GLOBALS['cfg']['mapset']}/{$map}.png";
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/{$GLOBALS['cfg']['mapset']}/default.webp";
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/{$GLOBALS['cfg']['mapset']}/default.jpg";
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/{$GLOBALS['cfg']['mapset']}/default.png";
                  $map_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/mapsets/default/default.webp";
                  $map_images[] = "../../games/default/mapsets/default/default.webp";

                  $no_of_map_images = count($map_images);
                  for ($i = 0; $i < $no_of_map_images; $i++) {
                    if (is_file($map_images[$i])) {
                      $map_image = $map_images[$i];
                      break;
                    }
                  }
                } ?>
                <td rowspan="6" class="cellSubHeading" style="text-align: left; padding: 0">
                  <img alt="" name="MAP" src="<?php print isset($map_image) ? $map_image : ''; ?>">
                </td>

              </tr>

              <tr>
                <td class="cellSubHeading" style="padding: 0 5px 0 5px; text-align: right">Map</td>
                <td width="100%" class="cell2" style="padding: 0 5px 0 5px; text-align: left"><?php if (isset($ggame['_v_map'])) { echo is_array($ggame['_v_map']) ? implode(', ', $ggame['_v_map']) : $ggame['_v_map']; } ?></td>
              </tr>

              <tr>
                <td class="cellSubHeading" style="padding: 0 5px 0 5px; text-align: right">Game</td>
                <td width="100%" class="cell1" style="padding: 0 5px 0 5px; text-align: left"><?php print isset($ggame['_v_game']) ? $ggame['_v_game'] : ''; ?></td>
              </tr>

              <tr>
                <td class="cellSubHeading" style="padding: 0 5px 0 5px; text-align: right">Mod</td>
                <td width="100%" class="cell2" style="padding: 0 5px 0 5px; text-align: left"><?php if (isset($ggame['_v_mod'])) { echo is_array($ggame['_v_mod']) ? implode(', ', $ggame['_v_mod']) : $ggame['_v_mod']; } ?></td>
              </tr>

              <tr>
                <td class="cellSubHeading" style="padding: 0 5px 0 5px; text-align: right">Game Type</td>
                <td width="100%" class="cell1" style="padding: 0 5px 0 5px; text-align: left"><?php if (isset($ggame['_v_game_type'])) {echo is_array($ggame['_v_game_type']) ? implode(', ', $ggame['_v_game_type']) : $ggame['_v_game_type']; } ?></td>
              </tr>

              <tr>
                <td class="cellSubHeading" style="padding: 0 5px 0 5px; text-align: right">Settings</td>

                <td width="100%" class="cell2" style="padding: 0 5px 0 5px; text-align: left">
                  <select class="cellSubHeading" style="text-align: left; width: 400px" name="GameSettings">
                    <?php
                    foreach ($ggame as $var => $val) {
                      if (!strstr($var, "_v_")) {
                        print "<option>$var: $val</option>";
                      }
                    } ?>
                  </select>
                </td>

              </tr>


            </table>
            <!-- game settings end   ##################################################-->
          <?php
        }
        //*************************************************************************
        function drawStats1D($playerID, $teamID, $eventCategory)
        {
          global $db;
          global $gmatrix1D, $gevent1D;

          $gevent1D_tmp = $gevent1D;

          $max_items = 0;
          foreach ($gevent1D_tmp as $eventCat => $val) {
            $max_new = count($val);
            if ($max_new > $max_items) {
              $max_items = $max_new;
            }
          } ?>
            <!-- events per category begin ##################################################-->
            <table class="vspmain" width="100%">
              <tr>
                <?php
                if ($playerID != '_v_player' && $eventCategory == "team") { // special case
                ?><td colspan="2" width="100%" class="cellSubHeading" style="text-align: left">&nbsp;</td><?php
                                                                                                } else {
                                                                                                  ?><td colspan="2" width="100%" class="cellSubHeading" style="text-align: left"><?php print fstr($eventCategory); ?>&nbsp;</td><?php
                                                                                                                                      } ?>
              </tr>
              <?php
              $count = 0;
              if (isset($gmatrix1D[$teamID][$playerID][$eventCategory])) {
                foreach ($gmatrix1D[$teamID][$playerID][$eventCategory] as $eventName => $eventValue) {
                  if ($count % 2 == 0) {
                    $cell_class = "cell1";
                  } else {
                    $cell_class = "cell2";
                  }
                  $count++;

                  //-------- special case
                  if ($playerID == '_v_player' && $eventCategory == "team") { // special case
                    $eventValue = $eventValue / (count($gmatrix1D[$teamID]) - 1);
                  } elseif ($eventCategory == "team") { // special case
              ?>
                    <tr class="<?php print "$cell_class" ?>">
                      <td>&nbsp;</td>
                      <td>&nbsp;</td>
                    </tr>
                  <?php
                    continue;
                  }
                  //-------- special case
                  ?>
                  <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">
                    <td width="70%" style="text-align: left"><?php print fstr($eventName); ?></td>
                    <td width="30%"><?php print fstr($eventValue); ?></td>
                  </tr>
                <?php
                }
              }

              for ($i = $count; $i < $max_items; $i++) {
                if ($i % 2 == 0) {
                  $cell_class = "cell1";
                } else {
                  $cell_class = "cell2";
                } ?>
                <tr class="<?php print $cell_class ?>">
                  <td width="70%">&nbsp;</td>
                  <td width="30%">&nbsp;</td>
                </tr>
              <?php
              } ?>
            </table>
            <!-- events per category end   ##################################################-->
          <?php
        }
        //*************************************************************************
        function drawWeaponStats($playerID, $teamID)
        {
          global $gmatrix, $gmatrixtotal, $gteam, $gweapon, $gplayerName, $gteam_index, $weapon_image, $team;
          if (is_array($gweapon) && count($gweapon) > 0) { ?>
            <!-- weaponstats table begin ##################################################-->
            <table class="vsppadding1" width="100%">
              <tr class="cellSubHeading">
                <td style="text-align: left;">Weapon</td>
                <td width="10%">Kills</td>
                <td width="10%">Deaths</td>
                <td width="10%">Suicides</td>
                <td width="10%">Eff %</td>
                <?php
                if (isset($GLOBALS['g_hitbox'])) {
                ?>
                  <td width="10%">Hits</td>
                  <td width="10%">Shots</td>
                  <td width="10%">Misses</td>
                  <td width="10%">Acc %</td>
                <?php
                } ?>
                <td width="1%" style="text-align: center;">&nbsp;</td>
              </tr>
              <?php

              $count = 0;
              foreach ($gweapon as $weapon => $val) {
                $count++;
                if ($count % 2 == 1) {
                  $cell_class = "cell1";
                } else {
                  $cell_class = "cell2";
                }

                $kills = isset($gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['kills']) ? $gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['kills'] : 0;
                $deaths = isset($gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['deaths']) ? $gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['deaths'] : 0;

                //----------
                // special case if playerid = '_v_player'
                if ($playerID == '_v_player') {
                  $suicides = isset($gmatrixtotal[$teamID][$playerID][$playerID][$weapon]['suicides']) ? $gmatrixtotal[$teamID][$playerID][$playerID][$weapon]['suicides'] : 0;
                } else {
                    $suicides = isset($gmatrix[$teamID][$playerID][$playerID][$weapon]['deaths']) ? $gmatrix[$teamID][$playerID][$playerID][$weapon]['deaths'] : 0;
                }
                //----------

                $hits = isset($gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['hits']) ? $gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['hits'] : 0;
                $shots = isset($gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['shots']) ? $gmatrixtotal[$teamID][$playerID]['_v_player'][$weapon]['shots'] : 0;

                if (isset($GLOBALS['weaponset'][$weapon]['name'])) {
                  $weapon_name = $GLOBALS['weaponset'][$weapon]['name'];
                } else {
                  $weapon_name = fstr($weapon);
                } ?>


                <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">

                  <?php
                  $weapon_images[] = "";
                  unset($weapon_images);
                  if (isset($GLOBALS['weaponset'][$weapon]['image'])) {
                    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$GLOBALS['weaponset'][$weapon]['image']}";
                  } else {
                    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$weapon}.webp";
                    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$weapon}.jpg";
                    $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/{$weapon}.png";
                  }

                  $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/default.webp";
                  $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/default.jpg";
                  $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/{$GLOBALS['cfg']['weaponset']}/default.png";

                  $weapon_images[] = "../../games/{$GLOBALS['cfg']['game']['name']}/weaponsets/default/default.webp";
                  $weapon_images[] = "../../games/default/weaponsets/default/default.webp";

                  $no_of_weapon_images = count($weapon_images);
                  for ($i = 0; $i < $no_of_weapon_images; $i++) {
                    if (is_file($weapon_images[$i])) {
                      $weapon_image = $weapon_images[$i];
                      break;
                    }
                  }
                  ?>
                  <td style="text-align: left"><?php print $weapon_name; ?></td>
                  <td><?php print $kills; ?></td>
                  <td><?php print $deaths; ?></td>
                  <td><?php print $suicides; ?></td>
                  <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>
                  <?php
                  if (isset($GLOBALS['g_hitbox'])) {
                  ?>
                    <td><?php print $hits; ?></td>
                    <td><?php print $shots; ?></td>
                    <td><?php print $shots - $hits; ?></td>
                    <td><?php printf("%02.2f", 100 * $hits / (0.00001 + $shots)); ?></td>
                  <?php
                  } ?>
                  <td width="1%" style="text-align: center">
                    <img alt="" src="<?php print $weapon_image; ?>">
                  </td>
                </tr>
              <?php
              }


              $kills = isset($gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['kills'] : 0;
              $deaths = isset($gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['deaths']) ? $gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['deaths'] : 0;

              //----------
              // special case if playerid = '_v_player'
              if ($playerID == '_v_player') {
                $suicides = isset($gmatrixtotal[$teamID][$playerID][$playerID]['_v_weapon']['suicides']) ? $gmatrixtotal[$teamID][$playerID][$playerID]['_v_weapon']['suicides'] : 0;
              } else {
                  $suicides = isset($gmatrixtotal[$teamID][$playerID][$playerID]['_v_weapon']['deaths']) ? $gmatrixtotal[$teamID][$playerID][$playerID]['_v_weapon']['deaths'] : 0;
              }
              //----------

              $hits = isset($gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['hits']) ? $gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['hits'] : 0;
              $shots = isset($gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['shots']) ? $gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['shots'] : 0;
              ?>


              <tr class="Team<?php print "$team{$gteam_index[$teamID]}" ?>">

                <td style="text-align: left; border-right:0 ">Total</td>
                <td><?php print $kills; ?></td>
                <td><?php print $deaths; ?></td>
                <td><?php print $suicides; ?></td>
                <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>
                <?php
                if (isset($GLOBALS['g_hitbox'])) {
                ?>
                  <td><?php print $hits; ?></td>
                  <td><?php print $shots; ?></td>
                  <td><?php print $shots - $hits; ?></td>
                  <td><?php printf("%02.2f", 100 * $hits / (0.00001 + $shots)); ?></td>
                <?php
                } ?>
                <td width="1%" style="text-align: center;">&nbsp;</td>
              </tr>


            </table>
            <!-- weaponstats table end ##################################################-->
          <?php
          } else {
            echo "No weapon data available.";
          }
        }

        //*************************************************************************
        function getStats1D()
        {
          global $db;
          global $gmatrix1D, $gplayerName, $gevent1D;
          global $gteam, $gicon;
          $sql = "SELECT playerName,team, ED1D.playerID, eventCategory, eventName, eventValue,role
            FROM {$GLOBALS['cfg']['db']['table_prefix']}eventdata1d as ED1D,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP
            WHERE gameID=$GLOBALS[gameID]
                  AND ED1D.playerID=PP.playerID
         ";

          $rs = $db->Execute($sql);

          if ($rs && !$rs->EOF) {
            do {
              $gplayerName[$rs->fields[2]] = $rs->fields[0];
              $gteam[$rs->fields[1]][$rs->fields[2]] = 1;

              if ($rs->fields[3] == 'icon') {
                if (!isset($gicon[$rs->fields[1]][$rs->fields[2]][$rs->fields[6]][$rs->fields[4]])) {
                  $gicon[$rs->fields[1]][$rs->fields[2]][$rs->fields[6]][$rs->fields[4]] = 0;
                }
                $gicon[$rs->fields[1]][$rs->fields[2]][$rs->fields[6]][$rs->fields[4]] += $rs->fields[5];
              } else {
                $gevent1D[$rs->fields[3]][$rs->fields[4]] = 1;

                if (!isset($gmatrix1D[$rs->fields[1]][$rs->fields[2]][$rs->fields[3]][$rs->fields[4]])) {
                  $gmatrix1D[$rs->fields[1]][$rs->fields[2]][$rs->fields[3]][$rs->fields[4]] = 0;
                }
                $gmatrix1D[$rs->fields[1]][$rs->fields[2]][$rs->fields[3]][$rs->fields[4]] += $rs->fields[5];


                if (!isset($gmatrix1D[$rs->fields[1]]['_v_player'][$rs->fields[3]][$rs->fields[4]])) {
                  $gmatrix1D[$rs->fields[1]]['_v_player'][$rs->fields[3]][$rs->fields[4]] = 0;
                }
                $gmatrix1D[$rs->fields[1]]['_v_player'][$rs->fields[3]][$rs->fields[4]] += $rs->fields[5];
              }
            } while ($rs->MoveNext());
          }


          if ($gevent1D) {
            ksort($gevent1D);
            foreach ($gevent1D as $cat => $event) {
              ksort($gevent1D[$cat]);
            }
          }

          if ($gmatrix1D) {
            foreach ($gmatrix1D as $teamIDi => $teamIDi_val) {
              foreach ($teamIDi_val as $playerIDi => $playerIDi_val) {
                foreach ($playerIDi_val as $eventCategoryi => $eventCategoryi_val) {
                  ksort($gmatrix1D[$teamIDi][$playerIDi][$eventCategoryi]);
                }
              }
            }
          }
        }
        //*************************************************************************
        function getStats()
        {
          global $db;
          global $gmatrix1D, $gevent1D;
          global $gmatrix, $gmatrixtotal, $gteam, $gweapon, $gplayerName;
          $sql = "select playerName,team, team2, ED2D.playerID, player2ID, eventName, eventValue, eventCategory,ED2D.role,ED2D.role2
            from {$GLOBALS['cfg']['db']['table_prefix']}eventdata2d as ED2D,{$GLOBALS['cfg']['db']['table_prefix']}playerprofile as PP
            where gameID=$GLOBALS[gameID]
                  AND ED2D.playerID=PP.playerID
         ";

          $rs = $db->Execute($sql);

          if ($rs && !$rs->EOF) {
            do {
              $gplayerName[$rs->fields[3]] = $rs->fields[0];

              // playerName of playerID2 might not get logged into $gplayerName, if thats the case just set it to null so that you can retrieve it from db later
              if (!isset($gplayerName[$rs->fields[4]])) {
                $gplayerName[$rs->fields[4]] = '';
              }


              $gteam[$rs->fields[1]][$rs->fields[3]] = 1;



              if (($rs->fields[7] == 'kill') || ($rs->fields[7] == 'teamkill') || ($rs->fields[7] == 'suicide')) {
                $gteam[$rs->fields[2]][$rs->fields[4]] = 1;
                $gweapon[$rs->fields[5]] = 1;


                //********** death matrix
                //000
                if (!isset($gmatrix[$rs->fields[2]][$rs->fields[4]][$rs->fields[3]][$rs->fields[5]]['deaths'])) {
                  $gmatrix[$rs->fields[2]][$rs->fields[4]][$rs->fields[3]][$rs->fields[5]]['deaths'] = 0;
                }
                $gmatrix[$rs->fields[2]][$rs->fields[4]][$rs->fields[3]][$rs->fields[5]]['deaths'] += $rs->fields[6];

                //001
                if (!isset($gmatrixtotal[$rs->fields[2]][$rs->fields[4]][$rs->fields[3]]['_v_weapon']['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]][$rs->fields[4]][$rs->fields[3]]['_v_weapon']['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]][$rs->fields[4]][$rs->fields[3]]['_v_weapon']['deaths'] += $rs->fields[6];

                //010
                if (!isset($gmatrixtotal[$rs->fields[2]][$rs->fields[4]]['_v_player'][$rs->fields[5]]['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]][$rs->fields[4]]['_v_player'][$rs->fields[5]]['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]][$rs->fields[4]]['_v_player'][$rs->fields[5]]['deaths'] += $rs->fields[6];

                //011
                if (!isset($gmatrixtotal[$rs->fields[2]][$rs->fields[4]]['_v_player']['_v_weapon']['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]][$rs->fields[4]]['_v_player']['_v_weapon']['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]][$rs->fields[4]]['_v_player']['_v_weapon']['deaths'] += $rs->fields[6];

                //100
                if (!isset($gmatrixtotal[$rs->fields[2]]['_v_player'][$rs->fields[4]][$rs->fields[5]]['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]]['_v_player'][$rs->fields[4]][$rs->fields[5]]['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]]['_v_player'][$rs->fields[4]][$rs->fields[5]]['deaths'] += $rs->fields[6];

                //101
                if (!isset($gmatrixtotal[$rs->fields[2]]['_v_player'][$rs->fields[4]]['_v_weapon']['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]]['_v_player'][$rs->fields[4]]['_v_weapon']['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]]['_v_player'][$rs->fields[4]]['_v_weapon']['deaths'] += $rs->fields[6];

                //110
                if (!isset($gmatrixtotal[$rs->fields[2]]['_v_player']['_v_player'][$rs->fields[5]]['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]]['_v_player']['_v_player'][$rs->fields[5]]['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]]['_v_player']['_v_player'][$rs->fields[5]]['deaths'] += $rs->fields[6];

                //111
                if (!isset($gmatrixtotal[$rs->fields[2]]['_v_player']['_v_player']['_v_weapon']['deaths'])) {
                  $gmatrixtotal[$rs->fields[2]]['_v_player']['_v_player']['_v_weapon']['deaths'] = 0;
                }
                $gmatrixtotal[$rs->fields[2]]['_v_player']['_v_player']['_v_weapon']['deaths'] += $rs->fields[6];
                //********** death matrix


                if ($rs->fields[7] == 'suicide') {
                  // make a separate entry for total and weapon suicides by a team because otherwise it will use the
                  // same position in the matrix as total deaths by a team

                  if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['suicides'])) {
                    $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['suicides'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['suicides'] += $rs->fields[6];

                  if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$rs->fields[5]]['suicides'])) {
                    $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$rs->fields[5]]['suicides'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$rs->fields[5]]['suicides'] += $rs->fields[6];
                } elseif ($rs->fields[7] == 'teamkill') {
                  $gevent1D['']['Team Kills'] = 1;
                  if (!isset($gmatrix1D[$rs->fields[1]][$rs->fields[3]]['']['Team Kills'])) {
                    $gmatrix1D[$rs->fields[1]][$rs->fields[3]]['']['Team Kills'] = 0;
                  }
                  $gmatrix1D[$rs->fields[1]][$rs->fields[3]]['']['Team Kills'] += $rs->fields[6];


                  $gevent1D['']['Team Deaths'] = 1;
                  if (!isset($gmatrix1D[$rs->fields[2]][$rs->fields[4]]['']['Team Deaths'])) {
                    $gmatrix1D[$rs->fields[2]][$rs->fields[4]]['']['Team Deaths'] = 0;
                  }
                  $gmatrix1D[$rs->fields[2]][$rs->fields[4]]['']['Team Deaths'] += $rs->fields[6];


                  if (!isset($gmatrix1D[$rs->fields[1]]['_v_player']['']['Team Kills'])) {
                    $gmatrix1D[$rs->fields[1]]['_v_player']['']['Team Kills'] = 0;
                  }
                  $gmatrix1D[$rs->fields[1]]['_v_player']['']['Team Kills'] += $rs->fields[6];

                  if (!isset($gmatrix1D[$rs->fields[2]]['_v_player']['']['Team Deaths'])) {
                    $gmatrix1D[$rs->fields[2]]['_v_player']['']['Team Deaths'] = 0;
                  }
                  $gmatrix1D[$rs->fields[2]]['_v_player']['']['Team Deaths'] += $rs->fields[6];
                } elseif ($rs->fields[7] == 'kill') {
                  //valid kill

                  //********** kill matrix
                  //000
                  if (!isset($gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$rs->fields[5]]['kills'])) {
                    $gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$rs->fields[5]]['kills'] = 0;
                  }
                  $gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$rs->fields[5]]['kills'] += $rs->fields[6];

                  //001
                  if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]]['_v_weapon']['kills'])) {
                    $gmatrixtotal[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]]['_v_weapon']['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]]['_v_weapon']['kills'] += $rs->fields[6];

                  //010
                  if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$rs->fields[5]]['kills'])) {
                    $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$rs->fields[5]]['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$rs->fields[5]]['kills'] += $rs->fields[6];

                  //011
                  if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['kills'])) {
                    $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['kills'] += $rs->fields[6];

                  //100
                  if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player'][$rs->fields[4]][$rs->fields[5]]['kills'])) {
                    $gmatrixtotal[$rs->fields[1]]['_v_player'][$rs->fields[4]][$rs->fields[5]]['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]]['_v_player'][$rs->fields[4]][$rs->fields[5]]['kills'] += $rs->fields[6];

                  //101
                  if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player'][$rs->fields[4]]['_v_weapon']['kills'])) {
                    $gmatrixtotal[$rs->fields[1]]['_v_player'][$rs->fields[4]]['_v_weapon']['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]]['_v_player'][$rs->fields[4]]['_v_weapon']['kills'] += $rs->fields[6];

                  //110
                  if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$rs->fields[5]]['kills'])) {
                    $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$rs->fields[5]]['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$rs->fields[5]]['kills'] += $rs->fields[6];

                  //111
                  if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['kills'])) {
                    $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['kills'] = 0;
                  }
                  $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['kills'] += $rs->fields[6];
                  //********** kill matrix
                }
              } elseif ($rs->fields[7] == 'accuracy') {
                if (preg_match("/^(.*)_(.*)/", $rs->fields[5], $ma)) {
                  $weapon = $ma[1];
                  $type = $ma[2];

                  if (!isset($gweapon[$weapon])) {
                    $gweapon[$weapon] = 1;
                  }

                  if ($type == 'hits') {
                    if (!isset($gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$weapon]['hits'])) {
                      $gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$weapon]['hits'] = 0;
                    }
                    $gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$weapon]['hits'] += $rs->fields[6];

                    if (!strcmp($rs->fields[3], $rs->fields[4])) { // ie the same
                      if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$weapon]['hits'])) {
                        $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$weapon]['hits'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$weapon]['hits'] += $rs->fields[6];


                      if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['hits'])) {
                        $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['hits'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['hits'] += $rs->fields[6];


                      if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$weapon]['hits'])) {
                        $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$weapon]['hits'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$weapon]['hits'] += $rs->fields[6];


                      if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['hits'])) {
                        $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['hits'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['hits'] += $rs->fields[6];
                    }
                  } elseif ($type == 'shots') {
                    $GLOBALS['g_hitbox']['ALL'] = 0; // just setting this since it is the same var as is playerstat.php, this is used to indicate if an accuracy info was scanned or not.
                    if (!isset($gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$weapon]['shots'])) {
                      $gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$weapon]['shots'] = 0;
                    }
                    $gmatrix[$rs->fields[1]][$rs->fields[3]][$rs->fields[4]][$weapon]['shots'] += $rs->fields[6];

                    if (!strcmp($rs->fields[3], $rs->fields[4])) { // ie the same
                      if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$weapon]['shots'])) {
                        $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$weapon]['shots'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player'][$weapon]['shots'] += $rs->fields[6];


                      if (!isset($gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['shots'])) {
                        $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['shots'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]][$rs->fields[3]]['_v_player']['_v_weapon']['shots'] += $rs->fields[6];


                      if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$weapon]['shots'])) {
                        $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$weapon]['shots'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player'][$weapon]['shots'] += $rs->fields[6];


                      if (!isset($gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['shots'])) {
                        $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['shots'] = 0;
                      }
                      $gmatrixtotal[$rs->fields[1]]['_v_player']['_v_player']['_v_weapon']['shots'] += $rs->fields[6];
                    }
                  }
                }
              } else {
                // PvP events. Just add as normal 1D event for now
                $gevent1D[$rs->fields[7]][$rs->fields[5]] = 1;

                if (!isset($gmatrix1D[$rs->fields[1]][$rs->fields[3]][$rs->fields[7]][$rs->fields[5]])) {
                  $gmatrix1D[$rs->fields[1]][$rs->fields[3]][$rs->fields[7]][$rs->fields[5]] = 0;
                }
                $gmatrix1D[$rs->fields[1]][$rs->fields[3]][$rs->fields[7]][$rs->fields[5]] += $rs->fields[6];

                if (!isset($gmatrix1D[$rs->fields[1]]['_v_player'][$rs->fields[7]][$rs->fields[5]])) {
                  $gmatrix1D[$rs->fields[1]]['_v_player'][$rs->fields[7]][$rs->fields[5]] = 0;
                }
                $gmatrix1D[$rs->fields[1]]['_v_player'][$rs->fields[7]][$rs->fields[5]] += $rs->fields[6];
              }
            } while ($rs->MoveNext());
          }




          if ($gweapon) {
            ksort($gweapon);
          }

        }
        //*************************************************************************
        function drawNavBar()
        {
          global $config, $sort; ?>
            <!-- navbar begin          ################################################-->
            <table class="cellHeading,vsppadding1" width="100%">
              <tr>
                <td class="cellHeading" style="border-right-width: 0; text-align: left;">
                  <!-- search form begin     ################################################-->
                  <form style="display:inline" method="post" action="<?php print "$_SERVER[PHP_SELF]?config=$config"; ?>">
                    <input class="cellSubHeading" style="text-align: center; border-width: 1px" type="Submit" name="goto_btn" value="&nbsp;goto #&nbsp;">
                    <input class="cellSubHeading" style="text-align: center; border-width: 1px" type="Text" name="goto_txt" size="15">
                  </form>
                  <!-- search form end       ################################################-->
                </td>


                <td class="cellHeading" style="border-left-width: 0; border-right-width: 0; text-align: left" width="100%">

                  <table class="vsppadding2" style="border-width: 0" width="100%">
                    <tr>
                      <td class="cellSubHeading pagination" style="text-align: left">
                        &nbsp;
                        <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from=0"; ?>"
                          class="pagination-link">First</a>
                        <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['prev']}"; ?>"
                          class="pagination-link">&laquo; Prev</a>
                        <span
                          class="pagination-info">Page<?php echo ceil($GLOBALS['start_from'] / $GLOBALS['cfg']['display']['record_limit']) + 1; ?>
                          of <?php echo ceil($GLOBALS['total_records'] / $GLOBALS['cfg']['display']['record_limit']); ?></span>
                        <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['next']}"; ?>"
                          class="pagination-link">Next &raquo;</a>
                        <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['total_records']}"; ?>"
                          class="pagination-link">Last</a>
                        &nbsp;
                      </td>

                      <td width="100%" style="border-width: 0; text-align: left">&nbsp;</td>
                    </tr>
                  </table>
                </td>



              </tr>
            </table>
            <!-- navbar end            ################################################-->
          <?php
        }
        //******************************************************************************

        function drawTeamOverall($teamID)
        {
          global $gmatrix, $gmatrixtotal, $gteam, $gweapon, $gplayerName, $gteam_index, $gevent1D;
          global $categories_per_row;

          // making a copy because foreach screws up if nested and using the same array
          $gteam_tmp = $gteam; ?>
            <!-- teamstat begin ############################################ -->
            <table class="vsppadding2" width="100%">
              <tr>
                <td colspan="5" style="font-size: 180%; text-align: center" width="100%" class="<?php print "team{$gteam_index[$teamID]}"; ?>">
                  Team <?php print $teamID; ?>
                </td>
              </tr>
            </table>
            <table class="sortable,vsppadding2" style="border-width: 0" width="100%" id="TeamOverallStats<?php print "team{$gteam_index[$teamID]}"; ?>">

              <tr class="cellSubHeading">
                <td width="40%" style="text-align: left">Name</td>
                <td width="15%" sortdir="down">Kills</td>
                <td width="15%">Deaths</td>
                <td width="15%">Suicides</td>
                <td width="15%">Eff %</td>

              </tr>

              <?php



              $no_of_rows = 0;
              foreach ($gteam_tmp as $team => $team_val) {
                $new_count = count($team_val);
                if ($new_count > $no_of_rows) {
                  $no_of_rows = $new_count;
                }
              }


              $count = 0;

              foreach ($gteam_tmp[$teamID] as $playerID => $val) {
                if ($count % 2 == 0) {
                  $cell_class = "cell1";
                } else {
                  $cell_class = "cell2";
                }
                $count++;


                $kills = isset($gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['kills'] : 0;
                $deaths = isset($gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['deaths']) ? $gmatrixtotal[$teamID][$playerID]['_v_player']['_v_weapon']['deaths'] : 0;
                $suicides = isset($gmatrixtotal[$teamID][$playerID][$playerID]['_v_weapon']['deaths']) ? $gmatrixtotal[$teamID][$playerID][$playerID]['_v_weapon']['deaths'] : 0;
                ?>

                <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">

                  <td style="text-align: left">
                    <a href="#stat-<?php print fstr($teamID . '-' . $playerID); ?>">
                      <?php print processColors(htmlspecialchars($gplayerName[$playerID]), $GLOBALS['settings']['display']['color_names'], $GLOBALS['settings']['display']['max_char_length']); ?>
                    </a>
                  </td>
                  <td><?php print $kills; ?></td>
                  <td><?php print $deaths; ?></td>
                  <td><?php print $suicides; ?></td>
                  <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>
                </tr>
              <?php
              }




              while ($count < $no_of_rows) {
                $count++;
                if ($count % 2 == 1) {
                  $cell_class = "cell1";
                } else {
                  $cell_class = "cell2";
                } ?>
                <tr sortbottom="1" class="<?php print $cell_class ?>">
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                </tr>
              <?php
              }


              $kills = isset($gmatrixtotal[$teamID]['_v_player']['_v_player']['_v_weapon']['kills']) ? $gmatrixtotal[$teamID]['_v_player']['_v_player']['_v_weapon']['kills'] : 0;
              $deaths = isset($gmatrixtotal[$teamID]['_v_player']['_v_player']['_v_weapon']['deaths']) ? $gmatrixtotal[$teamID]['_v_player']['_v_player']['_v_weapon']['deaths'] : 0;
              $suicides = isset($gmatrixtotal[$teamID]['_v_player']['_v_player']['_v_weapon']['suicides']) ? $gmatrixtotal[$teamID]['_v_player']['_v_player']['_v_weapon']['suicides'] : 0;
              ?>
              <tr sortbottom="1" class="<?php print "team{$gteam_index[$teamID]}"; ?>">
                <td style="text-align: left; "><?php print 'Total'; ?></td>
                <td><?php print $kills; ?></td>
                <td><?php print $deaths; ?></td>
                <td><?php print $suicides; ?></td>
                <td><?php printf("%02.2f", 100 * $kills / (0.00001 + $kills + $deaths)); ?></td>

              </tr>


            </table>

            <table class="vsppadding2" width="100%">




              <tr>
                <td colspan="1" style="border-width: 0; padding: 0; text-align: center" width="100%">



                  <table class="vspmain" width="100%">
                    <?php
                    $count_cat = 0;

                    if (isset($gevent1D)) {
                      foreach ($gevent1D as $eventCategory => $val) {
                        if ($count_cat % $categories_per_row == 0) {
                          echo "\n<tr>";
                        }

                        $count_cat++; ?>
                        <td width="<?php print round(100 / ($categories_per_row), 2) ?>%" class="cellBG" style="vertical-align: top; text-align: left ;border-width: 0; padding: 0">
                          <?php drawStats1D('_v_player', $teamID, $eventCategory); ?>
                        </td>
                      <?php

                        if ($count_cat % $categories_per_row == 0) {
                          echo "</tr>\n";
                        }
                      }
                    }

                    while ($count_cat % $categories_per_row != 0) {
                      if ($count_cat % $categories_per_row == 0) {
                        echo "\n<tr>";
                      }

                      $count_cat++; ?>
                      <td width="<?php print 100 / ($categories_per_row) ?>%" class="cellSubHeading" style="vertical-align: top; text-align: left ;border-width: 0; padding: 0">
                        <?php drawStats1D("", "", ""); ?>
                      </td>
                    <?php

                      if ($count_cat % $categories_per_row == 0) {
                        echo "</tr>\n";
                      }
                    } ?>
                    <tr>
                      <td colspan="<?php print $categories_per_row; ?>" width="100%" class="cellSubHeading" style="vertical-align: top; text-align: left; padding: 0">
                        <?php drawWeaponStats('_v_player', $teamID); ?>
                      </td>
                    </tr>
                  </table>







                </td>
              </tr>
















            </table>
            <!-- teamstat end          ################################################-->
            <?php
          }
          //*************************************************************************
          function drawGamesList()
          {
            global $db, $start_from, $config, $sort;

            $sql = "SELECT distinct gameID
          FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata 
          ORDER BY gameID DESC";
            $rs = $db->SelectLimit($sql, $GLOBALS['cfg']['display']['record_limit'], $GLOBALS['start_from']);
            if (!$rs) {
              return;
            }

            $gameID_max = $rs->fields[0];
            $rs->MoveLast();
            $gameID_min = $rs->fields[0];



            $sql = "SELECT gameID,name,value
              FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata 
              WHERE gameID >= $gameID_min
               AND gameID <= $gameID_max
               AND name LIKE '\\_v_%'
              ORDER BY gameID DESC,name ASC";
            $rs = $db->Execute($sql);

            if ($rs && !$rs->EOF) {
              $i = 0;
              $gameIDi = $rs->fields[0];
              do {
                $field_name[$i] = substr($rs->fields[1], 3); //get rid of the _v_
                $i++;
              } while ($rs->MoveNext() && $gameIDi == $rs->fields[0]);
              $field_name[$i] = 'Game';


              $no_of_field_names = count($field_name)

            ?>
              <!-- gamestats table begin ##################################################-->
              <table class="vsppadding2" width="100%">
                <tr>


                  <td colspan="4" class="cellHeading" style="text-align: left; border-right: 0">
                    Game Listing
                  </td>

                  <td colspan="<?php echo $no_of_field_names - 3; ?>" class="cellHeading" style="text-align: left; border-left: 0">

                    <table class="vsppadding2" width="100%">
                      <tr>
                        <td width="100%" style="border-width: 0; text-align: right">&nbsp;</td>
                      </tr>
                    </table>
                  </td>

                </tr>



                <tr>
                  <td class="cellSubHeading">#</td>

                  <?php
                  for ($i = 0; $i < $no_of_field_names; $i++) {
                  ?>
                    <td class="cellSubHeading" style="text-align: center"><?php print fstr($field_name[$i]); ?></td>
                  <?php
                  } ?>
                </tr>


                <?php
                $rs->Move(0);
                $count = 0;
                do {
                  $count++;
                  if ($count % 2 == 1) {
                    $cell_class = "cell1";
                  } else {
                    $cell_class = "cell2";
                  }

                  $gameIDi = $rs->fields[0]

                ?>
                  <tr class="<?php print $cell_class ?>" onMouseOver="this.className='rowHighlight';" onMouseOut="this.className='<?php print $cell_class ?>';">

                    <td>
                      <?php print $count + $start_from; ?>
                    </td>


                    <?php
                    do {
                    ?>
                      <td style="text-align: center;">
                        <?php
                        print $rs->fields[2]; ?>
                      </td>

                    <?php
                    } while ($rs->MoveNext() && $gameIDi == $rs->fields[0]); ?>


                    <td style="text-align: center;">
                      <a href="gamestat.php?gameID=<?php print $gameIDi . "&amp;config=$GLOBALS[config]"; ?>">Details
                        <?php
                        //print $rs->fields[0];
                        ?>
                      </a>
                    </td>


                  </tr>
                <?php
                } while (!$rs->EOF); ?>
                <tr>

                  <td colspan="11" class="cellHeading" style="border-left-width: 0; border-right-width: 0; text-align: left" width="100%">

                    <table class="vsppadding2" width="100%">
                      <tr>

                        <td width="100%" style="border-width: 0; text-align: left">&nbsp;
                          <!-- goto   form begin     ################################################-->
                          <form style="display:inline" method="post" action="<?php print "$_SERVER[PHP_SELF]?config=$config"; ?>">
                            <input class="cellSubHeading" style="text-align: center; border-width: 1" type="Submit" name="goto_btn" value="&thinsp;goto #&thinsp;">&nbsp;
                            <input class="cellSubHeading" style="text-align: center; border-width: 1" type="Text" name="goto_txt" size="10">
                          </form>
                          <!-- goto   form end       ################################################-->
                        </td>

                        <td class="cellSubHeading pagination" style="text-align: right">
                          &nbsp;
                          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from=0"; ?>" class="pagination-link">First</a>
                          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['prev']}"; ?>" class="pagination-link">&laquo; Prev</a>
                          <span class="pagination-info">Page<?php echo ceil($GLOBALS['start_from'] / $GLOBALS['cfg']['display']['record_limit']) + 1; ?>
                            of <?php echo ceil($GLOBALS['total_records'] / $GLOBALS['cfg']['display']['record_limit']); ?></span>
                          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['next']}"; ?>" class="pagination-link">Next &raquo;</a>
                          <a href="<?php print "$_SERVER[PHP_SELF]?config=$config&amp;sort=$sort&amp;start_from={$GLOBALS['total_records']}"; ?>" class="pagination-link">Last</a>
                          &nbsp;
                        </td>

                      </tr>
                    </table>


                  </td>
                </tr>

              </table>
              <!-- gamestats table end ##################################################-->
          <?php
            }
          }
          //*************************************************************************
          function setupVars()
          {
            global $db, $start_from, $prev, $next, $total_records;

            $sql = "SELECT count(distinct gameID) 
              FROM {$GLOBALS['cfg']['db']['table_prefix']}gamedata";
            $rs = $db->Execute($sql);
            $total_records = $rs->fields[0];



            //******************
            if (isset($_POST['goto_btn']) || isset($_POST['goto_txt'])) {
              //echo $_POST['goto_txt'];
              $start_from = intval($_POST['goto_txt']) - 1;
            } elseif (isset($_GET['start_from'])) {
              $start_from = $_GET['start_from'];
            }

            //********
            // limit checks
            if ($start_from >= $total_records) {
              $start_from = $total_records - $GLOBALS['cfg']['display']['record_limit'];
            }
            if (!isset($start_from) || $start_from < 0) {
              $start_from = 0;
            }
            //********
            //******************


            //******************
            $next = $start_from + $GLOBALS['cfg']['display']['record_limit'];
            $prev = $start_from - $GLOBALS['cfg']['display']['record_limit'];

            //********
            // limit checks
            if ($prev < 0) {
              $prev = 0;
            }

            if ($next > $total_records) {
              $next = $total_records;
            }
            //********
            //******************

            if (!is_dir("../../games/{$GLOBALS['cfg']['game']['name']}")) {
              $GLOBALS['cfg']['game']['name'] = 'default';
            }
          }
          //*************************************************************************

          ?>

          <!-- layout table begin ##################################################-->
          <table class="vspborderwidth2" width="100%">
            <tr>
              <td colspan="3" class="cellBG" style="vertical-align: top; padding: 0;">
                <?php drawMainHeading(); ?>
              </td>
            </tr>

            <tr>
              <td colspan="3" style="border-width: 0; padding: 0;">
                <?php drawMenu(); ?>
              </td>
            </tr>

            <?php
            if ($gameID) {
            ?>

              <tr>
                <td colspan="2" class="cellBG" style="vertical-align: top; padding: 10px 10px 10px 10px; border-width: 0;">
                  <?php drawHeadBar(); ?>
                </td>
              </tr>

              <tr>
                <td colspan="2" class="cellBG" style="vertical-align: top; padding: 0 10px 5px 10px; border-width: 0;">
                  <?php drawStatsGame(); ?>
                </td>
              </tr>

              <tr>
                <td colspan="2" class="cellBG" style="vertical-align: top; padding: 10px 5px 5px 5px; border-width: 0;">
                  <?php drawPlayerStats(); ?>
                </td>
              </tr>

              <?php
              if ($GLOBALS['settings']['display']['gamestats_killchart'] && count($GLOBALS['gplayerName']) < $GLOBALS['settings']['display']['gamestats_killchart']) {
              ?>
                <tr>
                  <td colspan="1" class="cellBG" style="vertical-align: top; padding: 0 10px 20px 10px; border-width: 0;">
                    <?php drawKillChart(); ?>
                  </td>
                </tr>
              <?php
              } ?>

            <?php
            } else {
            ?>

              <tr>
                <td colspan="2" class="cellBG" style="vertical-align: top; padding: 10px 10px 10px 10px; border-width: 0;">
                  <?php drawHeadBar(); ?>
                </td>
              </tr>

              <tr>
                <td colspan="2" class="cellBG" style="vertical-align: top; padding: 0 10px 10px 10px; border-width: 0;">
                  <?php drawGamesList(); ?>
                </td>
              </tr>
            <?php
            }
            ?>

            <tr>
              <td colspan="2" class="cellBG" style="vertical-align: top; padding: 0; border-width: 0;">
                <?php drawCredits(); ?>
              </td>
            </tr>
          </table>
          <!-- layout table end   ##################################################-->

</body>
</html>